/*
 * Decompiled with CFR 0.152.
 */
package es.urjc.escet.vido.agui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class JExplorer
extends JPanel {
    private List lastVisitedPages = new ArrayList();
    private int actualPage = -1;
    private JEditorPane HTMLDoc;
    private JTextField urlText;
    private JButton siguiente;
    private JButton anterior;

    public JExplorer() {
        this((URL)null);
    }

    public JExplorer(URL page) {
        this.setLayout(new BorderLayout());
        JPanel botonera = new JPanel();
        this.siguiente = new JButton(">");
        this.anterior = new JButton("<");
        this.siguiente.setEnabled(false);
        this.anterior.setEnabled(false);
        this.urlText = new JTextField(30);
        this.urlText.setEditable(false);
        this.urlText.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent arg0) {
                JExplorer.this.cambioTextField();
            }

            public void insertUpdate(DocumentEvent arg0) {
                JExplorer.this.cambioTextField();
            }

            public void removeUpdate(DocumentEvent arg0) {
                JExplorer.this.cambioTextField();
            }
        });
        this.siguiente.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                JExplorer.this.siguiente();
            }
        });
        this.anterior.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                JExplorer.this.anterior();
            }
        });
        botonera.add(this.anterior);
        botonera.add(this.siguiente);
        botonera.add(this.urlText);
        this.add((Component)botonera, "North");
        this.HTMLDoc = new JEditorPane();
        this.HTMLDoc.setEditable(false);
        this.HTMLDoc.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    JEditorPane pane = (JEditorPane)e.getSource();
                    if (e instanceof HTMLFrameHyperlinkEvent) {
                        HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                        HTMLDocument doc = (HTMLDocument)pane.getDocument();
                        doc.processHTMLFrameHyperlinkEvent(evt);
                    } else {
                        try {
                            URL url = e.getURL();
                            JExplorer.this.setPage(url);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                }
            }
        });
        if (page != null) {
            this.setPage(page);
        }
        this.add((Component)new JScrollPane(this.HTMLDoc), "Center");
    }

    public void setPage(URL url) {
        if (this.actualPage != -1 && this.actualPage != this.lastVisitedPages.size() - 1) {
            this.lastVisitedPages.subList(this.actualPage + 1, this.lastVisitedPages.size()).clear();
        }
        this.lastVisitedPages.add(url);
        this.actualPage = this.lastVisitedPages.size() - 1;
        this.loadPage(url);
        this.actualizaBotones();
    }

    protected void cambioTextField() {
    }

    protected void loadPage(URL url) {
        this.urlText.setText(url.toString());
        this.loadTextFieldPage();
    }

    protected void loadTextFieldPage() {
        try {
            URL url = new URL(this.urlText.getText());
            this.HTMLDoc.setPage(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void actualizaBotones() {
        if (this.actualPage == this.lastVisitedPages.size() - 1) {
            this.siguiente.setEnabled(false);
        } else {
            this.siguiente.setEnabled(true);
        }
        if (this.actualPage == 0) {
            this.anterior.setEnabled(false);
        } else {
            this.anterior.setEnabled(true);
        }
    }

    protected void anterior() {
        --this.actualPage;
        URL url = (URL)this.lastVisitedPages.get(this.actualPage);
        this.loadPage(url);
        this.actualizaBotones();
    }

    protected void siguiente() {
        ++this.actualPage;
        URL url = (URL)this.lastVisitedPages.get(this.actualPage);
        this.loadPage(url);
        this.actualizaBotones();
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        try {
            f.setContentPane(new JExplorer(new URL("http://www.google.es")));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        f.setDefaultCloseOperation(3);
        f.setSize(600, 600);
        f.setVisible(true);
    }
}

