/*
 * Decompiled with CFR 0.152.
 */
package es.urjc.escet.vido.agui.text;

import es.urjc.escet.vido.agui.text.LeafNode;
import es.urjc.escet.vido.agui.text.NodeContent;
import es.urjc.escet.vido.agui.text.TextEntity;
import es.urjc.escet.vido.agui.text.View;
import es.urjc.escet.vido.agui.text.event.NodeEvent;
import es.urjc.escet.vido.agui.text.event.NodeListener;
import java.util.List;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;

public abstract class Node
extends DefaultMutableTreeNode
implements TextEntity {
    Document document;
    boolean originalContent = true;
    NodeContent insertedContent;
    Position initCachedPosition;
    Position endCachedPosition;
    boolean visible = true;
    View view;
    private List nodeListeners = new Vector();

    protected Node(Document document) {
        this.document = document;
    }

    public abstract List getLeafs();

    public abstract Node getNodeFor(Object var1);

    public void replaceOriginalContent(NodeContent newContent) {
        if (!this.isOriginalContent()) {
            throw new Error("Content already replaced");
        }
        int posicionInicio = this.getStartPosition().getOffset();
        this.hide(posicionInicio);
        this.visible = true;
        newContent.insert(this.getStartPosition().getOffset(), this.document);
        try {
            this.initCachedPosition = this.document.createPosition(posicionInicio);
            Node nodo = (Node)this.getPreviousSibling();
            if (nodo != null) {
                if (nodo instanceof LeafNode) {
                    ((LeafNode)nodo).setEndPosition(this.initCachedPosition);
                } else {
                    LeafNode hoja = (LeafNode)nodo.getLastLeaf();
                    hoja.setEndPosition(this.initCachedPosition);
                }
            }
            this.endCachedPosition = this.getStartPosition();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.insertedContent = newContent;
        this.originalContent = false;
    }

    public void resetOriginalContent() {
        if (this.isOriginalContent()) {
            throw new Error("Is original content");
        }
        this.insertedContent.remove(this.getStartPosition().getOffset(), this.document);
        int offset = this.getStartPosition().getOffset();
        this.originalContent = true;
        this.visible = false;
        this.show(offset);
    }

    protected final void hide(int offsetInicio) {
        if (!this.isVisible()) {
            throw new Error("This node is not visible");
        }
        if (this.isOriginalContent()) {
            this.hideOriginalContent(offsetInicio);
        } else {
            this.insertedContent.remove(this.getStartPosition().getOffset(), this.document);
        }
        this.fireNodeEvent(true);
        this.visible = false;
    }

    protected final void show(int offset) {
        if (this.isVisible()) {
            throw new Error("This node is already visible");
        }
        if (this.isOriginalContent()) {
            this.showOriginalContent(offset);
        } else {
            try {
                this.endCachedPosition = this.document.createPosition(offset);
                this.insertedContent.insert(offset, this.document);
                this.initCachedPosition = this.document.createPosition(offset);
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        }
        this.fireNodeEvent(false);
        this.visible = true;
    }

    protected abstract void hideOriginalContent(int var1);

    protected abstract void showOriginalContent(int var1);

    public final Position getStartPosition() {
        if (!this.isOriginalContent()) {
            return this.initCachedPosition;
        }
        return this.getOriginalStartPosition();
    }

    public final Position getEndPosition() {
        if (!this.isOriginalContent()) {
            return this.endCachedPosition;
        }
        return this.getOriginalEndPosition();
    }

    protected abstract Position getOriginalStartPosition();

    protected abstract Position getOriginalEndPosition();

    public boolean isOriginalContent() {
        return this.originalContent;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void addNodeListener(NodeListener listener) {
        this.nodeListeners.add(listener);
    }

    public void removeNodeListener(NodeListener listener) {
        this.nodeListeners.remove(listener);
    }

    private void fireNodeEvent(boolean replaced) {
        NodeEvent e = new NodeEvent(this, replaced);
        int i = 0;
        while (i < this.nodeListeners.size()) {
            ((NodeListener)this.nodeListeners.get(i)).nodeAction(e);
            ++i;
        }
    }

    public void setView(View view) {
        this.view = view;
    }

    public View getView() {
        return this.view;
    }

    public AttributeSet getAttributes() {
        Element e = this.document.getDefaultRootElement();
        while (e.getElementIndex(this.getStartPosition().getOffset()) != -1) {
            e = e.getElement(e.getElementIndex(this.getStartPosition().getOffset()));
        }
        return e.getAttributes();
    }

    public Document getDocument() {
        return this.document;
    }
}

