/*
 * Decompiled with CFR 0.152.
 */
package es.urjc.escet.vido.agui.text;

import es.urjc.escet.vido.agui.text.InteractiveView;
import es.urjc.escet.vido.agui.text.LeafNode;
import es.urjc.escet.vido.agui.text.Node;
import es.urjc.escet.vido.agui.text.NodeContent;
import es.urjc.escet.vido.agui.text.View;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class NodeCollapsableView
extends View
implements InteractiveView,
MouseListener {
    NodeContent alternativeContent;
    protected boolean collapsed = false;
    JComponent interactiveComponent;
    List actionListeners = new ArrayList();

    public NodeCollapsableView(Node n) {
        this(n, NodeContent.LIST);
    }

    public NodeCollapsableView(Node n, NodeContent aContent) {
        super(n);
        this.alternativeContent = aContent;
    }

    public void action() {
        if (this.getNode().isOriginalContent()) {
            this.getNode().replaceOriginalContent(this.alternativeContent);
        } else {
            this.getNode().resetOriginalContent();
        }
        this.collapsed = !this.collapsed;
    }

    public Rectangle getInteractiveRegion(JTextComponent c) {
        try {
            Rectangle rInicio = c.modelToView(this.getNode().getStartPosition().getOffset());
            if (!this.getNode().isOriginalContent()) {
                return new Rectangle(rInicio.x - 14, rInicio.y + 4, 10, 10);
            }
            Rectangle rFin = c.modelToView(this.getNode().getEndPosition().getOffset());
            int menorX = rInicio.x < rFin.x ? rInicio.x : rFin.x;
            Rectangle rZona = new Rectangle(menorX - 14, rInicio.y + 4, 10, rFin.y + rFin.height - rInicio.y);
            return new Rectangle(rZona.x, rZona.y, rZona.width, rZona.height);
        }
        catch (BadLocationException e) {
            System.out.println("modelToView: " + this.toString());
            e.printStackTrace();
            return null;
        }
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void mouseClicked(MouseEvent e) {
        this.action();
        this.fireActionPerformed(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void setInteractiveComponent(JTextComponent text, JComponent c) {
        AttributeSet s = this.getNode().getAttributes();
        int fontSize = s != null ? StyleConstants.getFontSize(s.copyAttributes()) : 14;
        c.setFont(c.getFont().deriveFont(fontSize));
        int heightBoton = c.getFontMetrics(c.getFont()).getAscent();
        c.setAlignmentY(0.9f);
        c.setCursor(Cursor.getDefaultCursor());
        c.addMouseListener(this);
        c.setBorder(BorderFactory.createEmptyBorder());
        c.setPreferredSize(new Dimension(heightBoton, heightBoton));
        c.setMaximumSize(new Dimension(heightBoton, heightBoton));
        c.setMinimumSize(new Dimension(heightBoton, heightBoton));
        SimpleAttributeSet att = new SimpleAttributeSet();
        StyleConstants.setComponent(att, c);
        this.interactiveComponent = c;
        this.insertComponent(att);
    }

    protected void insertComponent(MutableAttributeSet att) {
        try {
            this.getNode().document.insertString(this.getNode().getStartPosition().getOffset(), " ", att);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        LeafNode hoja = new LeafNode(this.getNode().getStartPosition().getOffset() - 1, this.getNode().getStartPosition().getOffset());
        hoja.setDocument(this.getNode().document);
        hoja.createPositions();
        this.getNode().insert(hoja, 0);
    }

    public void addActionListener(ActionListener listener) {
        if (!this.actionListeners.contains(listener)) {
            this.actionListeners.add(listener);
        }
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.actionListeners.toArray();
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    public void fireActionPerformed(MouseEvent e) {
        int i = 0;
        while (i < this.actionListeners.size()) {
            ((ActionListener)this.actionListeners.get(i)).actionPerformed(new ActionEvent(e.getSource(), e.getID(), ""));
            ++i;
        }
    }

    public NodeContent getAlternativeContent() {
        return this.alternativeContent;
    }

    public void setAlternativeContent(NodeContent alternativeContent) {
        this.alternativeContent = alternativeContent;
    }
}

