/*
 * Decompiled with CFR 0.152.
 */
package es.urjc.escet.vido.jsd;

import es.urjc.escet.vido.jsd.GraphicPanel;
import es.urjc.escet.vido.jsd.XMLPersistent;
import java.awt.Cursor;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GraphicElement
implements XMLPersistent {
    final String GRAPHIC_ELEMENT = "GRAPHIC_ELEMENT";
    final String TYPE = "TYPE";
    final String CONFIGURATION = "CONFIGURATION";
    final String EXTENDED_CONFIGURATION = "EXTENDED_CONFIGURATION";
    final String ATTR_ID = "id";
    final String WIDTH = "WIDTH";
    final String HEIGHT = "HEIGHT";
    final String X_POSITION = "X_POSITION";
    final String Y_POSITION = "Y_POSITION";
    private JComponent comp;
    protected String estado = "inactivo";
    protected int pos_mov_x;
    protected int pos_mov_y;
    protected GraphicPanel panel;
    protected GraphicElement grupo;
    protected int id;
    protected int agrupation_level;

    protected JComponent getComponent() {
        return this.comp;
    }

    protected GraphicElement(GraphicPanel p) {
        this.panel = p;
        this.grupo = null;
        this.agrupation_level = 0;
    }

    GraphicElement(JComponent c, GraphicPanel p) {
        this.comp = c;
        this.panel = p;
        this.grupo = null;
        this.agrupation_level = 0;
    }

    public GraphicElement getGroup() {
        return this.grupo;
    }

    protected void setGroup(GraphicElement g) {
        this.grupo = g;
    }

    protected void setEnabled(boolean b) {
        this.comp.setEnabled(b);
    }

    public void move(int dx, int dy, int dwidth, int dheight) {
        int min_ancho = this.comp.getMinimumSize().width;
        int min_alto = this.comp.getMinimumSize().height;
        if (this.comp.getWidth() + dwidth < min_ancho) {
            return;
        }
        if (this.comp.getHeight() + dheight < min_alto) {
            return;
        }
        this.comp.setBounds(this.comp.getX() + dx, this.comp.getY() + dy, this.comp.getWidth() + dwidth, this.comp.getHeight() + dheight);
    }

    public void setBounds(int x, int y, int width, int height) {
        int min_ancho = this.comp.getMinimumSize().width;
        int min_alto = this.comp.getMinimumSize().height;
        if (width < min_ancho) {
            return;
        }
        if (height < min_alto) {
            return;
        }
        this.comp.setBounds(x, y, width, height);
    }

    public int getWidth() {
        return this.comp.getWidth();
    }

    public int getHeight() {
        return this.comp.getHeight();
    }

    public int getX() {
        return this.comp.getX();
    }

    public int getY() {
        return this.comp.getY();
    }

    protected int trasnformXCoordinate(JComponent c, int x) {
        int desplazamiento = c.getX() - this.getX();
        return x + desplazamiento;
    }

    protected int transformYCoordinate(JComponent c, int y) {
        int desplazamiento = c.getY() - this.getY();
        return y + desplazamiento;
    }

    protected void mouseMoveOverElement(int x, int y) {
        if (this.getWidth() - x < 5 && this.getHeight() - y < 5) {
            this.panel.setCursor(new Cursor(5));
        } else if (this.getWidth() - x < 5 && y < 5) {
            this.panel.setCursor(new Cursor(4));
        } else if (x < 5 && y < 5) {
            this.panel.setCursor(new Cursor(5));
        } else if (x < 5 && this.getHeight() - y < 5) {
            this.panel.setCursor(new Cursor(4));
        } else if (x < 5) {
            this.panel.setCursor(new Cursor(11));
        } else if (this.getWidth() - x < 5) {
            this.panel.setCursor(new Cursor(11));
        } else if (y < 5) {
            this.panel.setCursor(new Cursor(8));
        } else if (this.getHeight() - y < 5) {
            this.panel.setCursor(new Cursor(8));
        } else {
            this.panel.setCursor(new Cursor(13));
        }
    }

    protected void mousePressOverElement(int x, int y) {
        this.estado = this.getWidth() - x < 5 && this.getHeight() - y < 5 ? "redimension_inf_dch" : (this.getWidth() - x < 5 && y < 5 ? "redimension_sup_dch" : (x < 5 && y < 5 ? "redimension_sup_izqd" : (x < 5 && this.getHeight() - y < 5 ? "redimension_inf_izqd" : (x < 5 ? "redimension_borde_izqd" : (this.getWidth() - x < 5 ? "redimension_borde_dch" : (y < 5 ? "redimension_borde_sup" : (this.getHeight() - y < 5 ? "redimension_borde_inf" : "movimiento")))))));
        this.pos_mov_x = x;
        this.pos_mov_y = y;
    }

    protected void mouseDraggedOverElement(int x, int y) {
        if (this.estado == "movimiento") {
            int desp_x = x - this.pos_mov_x;
            int desp_y = y - this.pos_mov_y;
            this.move(desp_x, desp_y, 0, 0);
        } else if (this.estado == "redimension_inf_dch") {
            int desp_x = x - this.pos_mov_x;
            int desp_y = y - this.pos_mov_y;
            this.pos_mov_x = x;
            this.pos_mov_y = y;
            this.move(0, 0, desp_x, desp_y);
        } else if (this.estado == "redimension_sup_dch") {
            int desp_x = x - this.pos_mov_x;
            int desp_y = y - this.pos_mov_y;
            this.pos_mov_x = x;
            this.move(0, desp_y, desp_x, -desp_y);
        } else if (this.estado == "redimension_sup_izqd") {
            int desp_x = x - this.pos_mov_x;
            int desp_y = y - this.pos_mov_y;
            this.move(desp_x, desp_y, -desp_x, -desp_y);
        } else if (this.estado == "redimension_inf_izqd") {
            int desp_x = x - this.pos_mov_x;
            int desp_y = y - this.pos_mov_y;
            this.pos_mov_y = y;
            this.move(desp_x, 0, -desp_x, desp_y);
        } else if (this.estado == "redimension_borde_izqd") {
            int desp_x = x - this.pos_mov_x;
            int desp_y = y - this.pos_mov_y;
            this.move(desp_x, 0, -desp_x, 0);
        } else if (this.estado == "redimension_borde_dch") {
            int despX = x - this.pos_mov_x;
            int despY = y - this.pos_mov_y;
            this.pos_mov_x = x;
            this.move(0, 0, despX, 0);
        } else if (this.estado == "redimension_borde_sup") {
            int despX = x - this.pos_mov_x;
            int despY = y - this.pos_mov_y;
            this.move(0, despY, 0, -despY);
        } else if (this.estado == "redimension_borde_inf") {
            int despX = x - this.pos_mov_x;
            int despY = y - this.pos_mov_y;
            this.pos_mov_y = y;
            this.move(0, 0, 0, despY);
        }
    }

    protected void mouseReleasedOverElement() {
        this.estado = "inactivo";
    }

    public void readXML(Node nodo_xml) {
        if (nodo_xml.getNodeType() != 1) {
            return;
        }
        Element elem = (Element)nodo_xml;
        String id_graphic_elem = elem.getAttribute("id");
        this.setId(Integer.parseInt(id_graphic_elem));
        this.comp = this.createComponent(elem);
    }

    private JComponent createComponent(Element e) {
        JComponent c = null;
        Element type = (Element)e.getElementsByTagName("TYPE").item(0);
        String tipo = type.getChildNodes().item(0).getNodeValue();
        try {
            c = (JComponent)Class.forName(tipo).newInstance();
        }
        catch (InstantiationException e1) {
            c = new JButton();
        }
        catch (IllegalAccessException e1) {
            c = new JButton();
        }
        catch (ClassNotFoundException e1) {
            c = new JButton();
        }
        if (c instanceof XMLPersistent) {
            Element comp_config = (Element)e.getElementsByTagName("EXTENDED_CONFIGURATION").item(0);
            ((XMLPersistent)((Object)c)).readXML(comp_config);
        }
        Element config = (Element)e.getElementsByTagName("CONFIGURATION").item(0);
        Element widht = (Element)config.getElementsByTagName("WIDTH").item(0);
        String ancho = widht.getChildNodes().item(0).getNodeValue();
        Element height = (Element)config.getElementsByTagName("HEIGHT").item(0);
        String alto = height.getChildNodes().item(0).getNodeValue();
        Element x_position = (Element)config.getElementsByTagName("X_POSITION").item(0);
        String x_pos = x_position.getChildNodes().item(0).getNodeValue();
        Element y_position = (Element)config.getElementsByTagName("Y_POSITION").item(0);
        String y_pos = y_position.getChildNodes().item(0).getNodeValue();
        int ancho_final = c.getMinimumSize().getWidth() > (double)Integer.parseInt(ancho) ? (int)c.getMinimumSize().getWidth() : Integer.parseInt(ancho);
        int alto_final = c.getMinimumSize().getHeight() > (double)Integer.parseInt(alto) ? (int)c.getMinimumSize().getHeight() : Integer.parseInt(alto);
        c.setSize(ancho_final, alto_final);
        c.setLocation(Integer.parseInt(x_pos), Integer.parseInt(y_pos));
        return c;
    }

    protected int getId() {
        return this.id;
    }

    protected void setId(int id) {
        this.id = id;
    }

    public int getAgrupationLevel() {
        return this.agrupation_level;
    }

    public void writeXML(Document d, Element e) {
        Element graphic_element = d.createElement("GRAPHIC_ELEMENT");
        graphic_element.setAttribute("id", Integer.toString(this.id));
        e.appendChild(graphic_element);
        Element type_element = d.createElement("TYPE");
        type_element.appendChild(d.createTextNode(this.getComponent().getClass().getName()));
        graphic_element.appendChild(type_element);
        Element configuration_element = d.createElement("CONFIGURATION");
        Element widht_node = d.createElement("WIDTH");
        widht_node.appendChild(d.createTextNode(Integer.toString(this.getWidth())));
        configuration_element.appendChild(widht_node);
        Element height_node = d.createElement("HEIGHT");
        height_node.appendChild(d.createTextNode(Integer.toString(this.getHeight())));
        configuration_element.appendChild(height_node);
        Element x_node = d.createElement("X_POSITION");
        x_node.appendChild(d.createTextNode(Integer.toString(this.getX())));
        configuration_element.appendChild(x_node);
        Element y_node = d.createElement("Y_POSITION");
        y_node.appendChild(d.createTextNode(Integer.toString(this.getY())));
        configuration_element.appendChild(y_node);
        graphic_element.appendChild(configuration_element);
        if (this.getComponent() instanceof XMLPersistent) {
            Element comp_config = d.createElement("EXTENDED_CONFIGURATION");
            ((XMLPersistent)((Object)this.getComponent())).writeXML(d, comp_config);
            graphic_element.appendChild(comp_config);
        }
    }
}

