/*
 * Decompiled with CFR 0.152.
 */
package es.urjc.escet.vido.jsd;

import es.urjc.escet.vido.jsd.Connector;
import es.urjc.escet.vido.jsd.GraphicElement;
import es.urjc.escet.vido.jsd.GraphicElementsGroup;
import es.urjc.escet.vido.jsd.SelectionRectangle;
import es.urjc.escet.vido.jsd.XMLPersistent;
import es.urjc.escet.vido.jsd.connector.draw.DrawConnector;
import es.urjc.escet.vido.jsd.connector.draw.DrawConnectorsFactory;
import es.urjc.escet.vido.jsd.group.draw.DrawGroup;
import es.urjc.escet.vido.jsd.group.draw.DrawGroupsFactory;
import es.urjc.escet.vido.jsd.group.draw.SimpleDrawGroup;
import es.urjc.escet.vido.jsd.group.operation.GroupOperation;
import es.urjc.escet.vido.jsd.group.operation.GroupOperationsFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GraphicPanel
extends JPanel
implements ActionListener,
XMLPersistent {
    private HashMap<JComponent, GraphicElement> mapa_componentes = new HashMap();
    private HashMap<Integer, GraphicElement> mapa_elementos = new HashMap();
    private int cont_id_elementos = 1;
    private HashMap<Integer, List<GraphicElement>> mapa_niveles_agrupacion = new HashMap();
    private int max_nivel_agrupacion = 0;
    private boolean Crtl_presionado = false;
    private boolean dibujando_conector = false;
    private boolean dibujando_cuadro_seleccion = false;
    private Connector conector_en_movimiento = null;
    private int puerto_en_movimiento = -1;
    private GraphicElementsGroup grupo_activo;
    private JComponent ultimo_componente_lanzar_popup;
    private GraphicElement ultimo_elemento_lanzar_popup;
    private Connector conector_temporal;
    private SelectionRectangle cuadro_seleccion = null;
    private List<Connector> vector_conectores = new ArrayList<Connector>();
    private Connector conector_actual;
    private int traza_conector_actual;
    private int x_sobre_conector_actual;
    private int y_sobre_conector_actual;
    private int codo_conector_actual;
    private int zona_anclaje_actual;
    private GraphicPanel panel;
    private boolean popupMenuEnabled;
    private JPopupMenu menu_popup = new JPopupMenu();
    private JMenuItem item_remove = new JMenuItem("Remove");
    private JMenuItem item_hacer_persistente = new JMenuItem("Group");
    private JMenuItem item_deshacer_persistente = new JMenuItem("Ungroup");
    private JPopupMenu menu_popup_panel = new JPopupMenu("Opciones del panel");
    private JMenuItem item_activar = new JMenuItem("Design mode");
    private JMenuItem item_desactivar = new JMenuItem("Static mode");
    private JMenuItem item_grabar_svg = new JMenuItem("Export to SVG");
    private JMenuItem item_grabar_xml = new JMenuItem("Save file");
    private JMenuItem item_abrir_xml = new JMenuItem("Open file");
    private boolean designMode = true;
    private JPopupMenu menu_popup_conector = new JPopupMenu();
    private JMenuItem item_borrar_conector = new JMenuItem("Remove conector");
    private JMenuItem item_crear_codo = new JMenuItem("New control point");
    private JMenuItem item_borrar_codo = new JMenuItem("Remove control point");
    private JMenuItem item_anclar = new JMenuItem("Create port");
    private JMenuItem item_quitar_anclaje = new JMenuItem("Remove port");
    private JMenu menu_grupos = new JMenu("Group type");
    private HashMap<String, DrawGroupsFactory> factorias_grupos = new HashMap();
    private DrawGroup dg_actual;
    private JMenu menu_conectores = new JMenu("Conectors");
    private HashMap<String, DrawConnectorsFactory> factorias_conectores = new HashMap();
    private JMenu menu_operaciones_grupo = new JMenu("Group operations");
    private HashMap<String, GroupOperationsFactory> factorias_operaciones_grupo = new HashMap();
    final String GRAPHIC_PANEL = "GRAPHIC_PANEL";
    final String GRAPHIC_ELEMENT = "GRAPHIC_ELEMENT";
    final String TYPE = "TYPE";
    final String ELEMENT_GROUP = "ELEMENT_GROUP";
    final String CONECTOR = "CONECTOR";

    public GraphicPanel() {
        super(null);
        this.setBackground(Color.WHITE);
        this.menu_popup.add(this.menu_conectores);
        this.menu_popup.add(this.item_remove);
        this.menu_popup.add(this.item_hacer_persistente);
        this.menu_popup.add(this.item_deshacer_persistente);
        this.menu_popup.add(this.menu_operaciones_grupo);
        this.menu_popup_panel.add(this.item_activar);
        this.menu_popup_panel.add(this.item_desactivar);
        this.menu_popup_panel.add(this.item_grabar_svg);
        this.menu_popup_panel.add(this.item_grabar_xml);
        this.menu_popup_panel.add(this.item_abrir_xml);
        this.menu_popup_panel.add(this.menu_grupos);
        this.menu_popup_conector.add(this.item_borrar_conector);
        this.menu_popup_conector.add(this.item_crear_codo);
        this.menu_popup_conector.add(this.item_borrar_codo);
        this.menu_popup_conector.add(this.item_anclar);
        this.menu_popup_conector.add(this.item_quitar_anclaje);
        this.ControlTeclado();
        this.ControlPopup();
        this.ControlMousePanel();
        this.panel = this;
        this.activateDesignMode();
        this.dg_actual = new SimpleDrawGroup();
        this.grupo_activo = new GraphicElementsGroup(this, this.dg_actual);
        this.removeAll();
    }

    public void add(JComponent c) {
        GraphicElement elemento = new GraphicElement(c, this);
        elemento.setId(this.cont_id_elementos);
        ++this.cont_id_elementos;
        this.add(elemento);
        this.validate();
        this.repaint();
        this.scrollRectToVisible(c.getBounds());
    }

    private void add(GraphicElement ge) {
        if (!(ge instanceof GraphicElementsGroup)) {
            this.ControlMouseComponentes(ge.getComponent());
            this.ControlMovimientoComponentes(ge.getComponent());
            if (this.designMode) {
                ge.getComponent().setEnabled(false);
            }
            super.add(ge.getComponent());
            this.mapa_componentes.put(ge.getComponent(), ge);
        } else {
            ((GraphicElementsGroup)ge).setPersistent(true);
        }
        this.mapa_elementos.put(new Integer(ge.getId()), ge);
        this.cont_id_elementos = ge.getId() + 1;
        int nivel_agrupacion = ge.getAgrupationLevel();
        List<GraphicElement> v = this.mapa_niveles_agrupacion.get(new Integer(nivel_agrupacion));
        if (v == null) {
            ArrayList<GraphicElement> v_aux = new ArrayList<GraphicElement>();
            this.mapa_niveles_agrupacion.put(new Integer(nivel_agrupacion), v_aux);
            v = v_aux;
            if (nivel_agrupacion > this.max_nivel_agrupacion) {
                this.max_nivel_agrupacion = nivel_agrupacion;
            }
        }
        v.add(ge);
        this.validate();
    }

    public void remove(JComponent c) {
        GraphicElement ge = this.getGraphicElement(c);
        this.remove(ge);
        this.refreshSize();
    }

    public void remove(GraphicElement e) {
        if (e != this.grupo_activo) {
            List<GraphicElement> v = this.mapa_niveles_agrupacion.get(new Integer(e.getAgrupationLevel()));
            v.remove(e);
            this.borrarConectores(e);
        }
        if (e.getAgrupationLevel() == 0) {
            super.remove(e.getComponent());
        } else {
            int i = 0;
            while (i < ((GraphicElementsGroup)e).size()) {
                this.borrarConectores(e);
                this.remove(((GraphicElementsGroup)e).getElement(i));
                ++i;
            }
        }
        if (e == this.grupo_activo) {
            this.grupo_activo.removeAllElements();
        }
        this.repaint();
    }

    public void addConnector(Connector c) {
        this.vector_conectores.add(c);
        this.repaint();
    }

    public void removeConnector(Connector c) {
        this.vector_conectores.remove(c);
        this.repaint();
    }

    public GraphicElement getGraphicElement(JComponent c) {
        return this.mapa_componentes.get(c);
    }

    public void insertGroupOperationFactoy(GroupOperationsFactory gof) {
        this.factorias_operaciones_grupo.put(gof.getFactoryName(), gof);
        JMenu menu_factoria = gof.getOperationsMenu();
        this.menu_operaciones_grupo.add(menu_factoria);
        int i = 0;
        while (i < menu_factoria.getItemCount()) {
            menu_factoria.getItem(i).addActionListener(this);
            ++i;
        }
    }

    public void removeGroupOperationsFactory(GroupOperationsFactory gof) {
        this.factorias_operaciones_grupo.remove(gof);
    }

    public void insertGroupDrawerFactory(DrawGroupsFactory dgf) {
        this.factorias_grupos.put(dgf.getFactoryName(), dgf);
        JMenu menu_factoria = dgf.getDrawersMenu();
        this.menu_grupos.add(menu_factoria);
        int i = 0;
        while (i < menu_factoria.getItemCount()) {
            menu_factoria.getItem(i).addActionListener(this);
            ++i;
        }
    }

    public void removeGroupDrawerFactory(DrawGroupsFactory dgf) {
        this.factorias_grupos.remove(dgf);
    }

    public void insertConnectorsFactory(DrawConnectorsFactory dcf) {
        this.factorias_conectores.put(dcf.getFactoryName(), dcf);
        JMenu menu_factoria = dcf.getDrawersMenu();
        this.menu_conectores.add(menu_factoria);
        int i = 0;
        while (i < menu_factoria.getItemCount()) {
            menu_factoria.getItem(i).addActionListener(this);
            ++i;
        }
    }

    public void removeConnectorsFactory(DrawConnectorsFactory dcf) {
        this.factorias_conectores.remove(dcf);
    }

    protected GraphicElement getGraphicElement(int id) {
        return this.mapa_elementos.get(new Integer(id));
    }

    public void paint(Graphics g) {
        super.paint(g);
        List<GraphicElement> v_nivel0 = this.mapa_niveles_agrupacion.get(new Integer(0));
        Dimension d = this.getSize();
        int max_x = d.width;
        int max_y = d.height;
        if (v_nivel0 != null) {
            int i = 0;
            while (i < v_nivel0.size()) {
                GraphicElement e = v_nivel0.get(i);
                if (e.getX() + e.getWidth() > max_x) {
                    max_x = e.getX() + e.getWidth();
                }
                if (e.getY() + e.getHeight() > max_y) {
                    max_y = e.getY() + e.getHeight();
                }
                ++i;
            }
        }
        Dimension d_final = new Dimension(max_x, max_y);
        this.setPreferredSize(d_final);
        this.setSize(d_final);
        this.grupo_activo.paint((Graphics2D)g);
        int i = this.max_nivel_agrupacion;
        while (i > 0) {
            Vector v_aux = (Vector)this.mapa_niveles_agrupacion.get(new Integer(i));
            if (v_aux != null) {
                int j = 0;
                while (j < v_aux.size()) {
                    ((GraphicElementsGroup)v_aux.get(j)).paint((Graphics2D)g);
                    ++j;
                }
            }
            --i;
        }
        i = 0;
        while (i < this.vector_conectores.size()) {
            Connector c = this.vector_conectores.get(i);
            c.paint((Graphics2D)g);
            ++i;
        }
        if (this.dibujando_conector) {
            this.conector_temporal.paint((Graphics2D)g);
        }
        if (this.cuadro_seleccion != null) {
            this.cuadro_seleccion.paint((Graphics2D)g);
        }
    }

    private void activateDesignMode() {
        Vector v_nivel0 = (Vector)this.mapa_niveles_agrupacion.get(new Integer(0));
        if (v_nivel0 != null) {
            int i = 0;
            while (i < v_nivel0.size()) {
                GraphicElement e = (GraphicElement)v_nivel0.get(i);
                e.setEnabled(false);
                ++i;
            }
        }
    }

    private void activateStaticMode() {
        Vector v_nivel0 = (Vector)this.mapa_niveles_agrupacion.get(new Integer(0));
        if (v_nivel0 != null) {
            int i = 0;
            while (i < v_nivel0.size()) {
                GraphicElement e = (GraphicElement)v_nivel0.get(i);
                e.setEnabled(true);
                ++i;
            }
        }
    }

    private void ControlTeclado() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            public boolean dispatchKeyEvent(KeyEvent e) {
                if (GraphicPanel.this.designMode) {
                    if (e.getID() == 401) {
                        if (e.getKeyCode() == 17) {
                            GraphicPanel.this.Crtl_presionado = true;
                        }
                    } else if (e.getID() == 402 && e.getKeyCode() == 17) {
                        GraphicPanel.this.Crtl_presionado = false;
                    }
                }
                return false;
            }
        });
    }

    private void ControlPopup() {
        this.item_desactivar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphicPanel.this.activateStaticMode();
            }
        });
        this.item_activar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphicPanel.this.activateDesignMode();
            }
        });
        this.item_hacer_persistente.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphicPanel.this.grupo_activo.setPersistent(true);
                GraphicPanel.this.grupo_activo.setId(GraphicPanel.this.cont_id_elementos);
                int nivel_agrupacion = GraphicPanel.this.grupo_activo.getAgrupationLevel();
                ArrayList<GraphicElementsGroup> v = (ArrayList<GraphicElementsGroup>)GraphicPanel.this.mapa_niveles_agrupacion.get(new Integer(nivel_agrupacion));
                if (v == null) {
                    ArrayList<GraphicElementsGroup> v_aux = new ArrayList<GraphicElementsGroup>();
                    GraphicPanel.this.mapa_niveles_agrupacion.put(new Integer(nivel_agrupacion), v_aux);
                    v = v_aux;
                    if (nivel_agrupacion > GraphicPanel.this.max_nivel_agrupacion) {
                        GraphicPanel.this.max_nivel_agrupacion = nivel_agrupacion;
                    }
                }
                v.add(GraphicPanel.this.grupo_activo);
                GraphicPanel.this.grupo_activo = new GraphicElementsGroup(GraphicPanel.this, GraphicPanel.this.dg_actual);
                GraphicPanel.this.repaint();
            }
        });
        this.item_deshacer_persistente.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GraphicPanel.this.ultimo_elemento_lanzar_popup instanceof GraphicElementsGroup) {
                    GraphicPanel.this.deshacerPersistencia((GraphicElementsGroup)GraphicPanel.this.ultimo_elemento_lanzar_popup);
                }
                GraphicPanel.this.repaint();
            }
        });
        this.item_remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphicPanel.this.remove(GraphicPanel.this.ultimo_elemento_lanzar_popup);
                GraphicPanel.this.repaint();
            }
        });
        this.item_borrar_conector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int i = 0;
                while (i < GraphicPanel.this.vector_conectores.size()) {
                    Connector c = (Connector)GraphicPanel.this.vector_conectores.get(i);
                    if (c == GraphicPanel.this.conector_actual) {
                        GraphicPanel.this.vector_conectores.remove(GraphicPanel.this.conector_actual);
                    }
                    ++i;
                }
                GraphicPanel.this.repaint();
            }
        });
        this.item_crear_codo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphicPanel.this.conector_actual.setControlPoint(GraphicPanel.this.x_sobre_conector_actual, GraphicPanel.this.y_sobre_conector_actual, GraphicPanel.this.traza_conector_actual);
                GraphicPanel.this.repaint();
            }
        });
        this.item_borrar_codo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphicPanel.this.conector_actual.removeControlPoint(GraphicPanel.this.codo_conector_actual);
                GraphicPanel.this.repaint();
            }
        });
        this.item_anclar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println(GraphicPanel.this.zona_anclaje_actual);
                if (GraphicPanel.this.zona_anclaje_actual == 1) {
                    GraphicPanel.this.conector_actual.setOriginAnchor(true);
                } else {
                    GraphicPanel.this.conector_actual.setEndAnchor(true);
                }
                GraphicPanel.this.repaint();
            }
        });
        this.item_quitar_anclaje.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GraphicPanel.this.zona_anclaje_actual == 1) {
                    GraphicPanel.this.conector_actual.setOriginAnchor(false);
                } else {
                    GraphicPanel.this.conector_actual.setEndAnchor(false);
                }
                GraphicPanel.this.repaint();
            }
        });
        this.item_grabar_svg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File f = null;
                JFileChooser fc = new JFileChooser(".");
                int choice = fc.showSaveDialog(GraphicPanel.this.panel);
                if (choice == 0) {
                    f = fc.getSelectedFile();
                }
                try {
                    GraphicPanel.this.saveAsSVG(f);
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
                catch (SVGGraphics2DIOException e1) {
                    e1.printStackTrace();
                }
                catch (UnsupportedEncodingException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.item_grabar_xml.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File f = null;
                JFileChooser fc = new JFileChooser(".");
                int choice = fc.showSaveDialog(GraphicPanel.this.panel);
                if (choice == 0) {
                    f = fc.getSelectedFile();
                }
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                try {
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document document = builder.newDocument();
                    GraphicPanel.this.panel.writeXML(document, null);
                    DOMSource source = new DOMSource(document);
                    StreamResult result = new StreamResult(f);
                    Transformer xformer = TransformerFactory.newInstance().newTransformer();
                    xformer.transform(source, result);
                }
                catch (TransformerException e1) {
                    e1.printStackTrace();
                }
                catch (ParserConfigurationException pce) {
                    pce.printStackTrace();
                }
            }
        });
        this.item_abrir_xml.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File f = null;
                JFileChooser fc = new JFileChooser(".");
                int choice = fc.showOpenDialog(GraphicPanel.this.panel);
                if (choice == 0) {
                    f = fc.getSelectedFile();
                }
                DocumentBuilderFactory factoria = DocumentBuilderFactory.newInstance();
                factoria.setNamespaceAware(true);
                factoria.setValidating(false);
                DocumentBuilder builder = null;
                Document document = null;
                try {
                    builder = factoria.newDocumentBuilder();
                    document = builder.parse(f);
                }
                catch (ParserConfigurationException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                catch (SAXException e1) {
                    e1.printStackTrace();
                }
                GraphicPanel.this.panel.readXML(document);
                GraphicPanel.this.panel.repaint();
            }
        });
    }

    private void ControlMousePanel() {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                if (GraphicPanel.this.designMode && GraphicPanel.this.dibujando_conector) {
                    GraphicPanel.this.conector_temporal.tempCoordinates(e.getX(), e.getY());
                    GraphicPanel.this.repaint();
                }
            }

            public void mouseDragged(MouseEvent e) {
                if (GraphicPanel.this.dibujando_cuadro_seleccion) {
                    GraphicPanel.this.cuadro_seleccion.finalPosition(e.getX(), e.getY());
                    GraphicPanel.this.repaint();
                } else if (GraphicPanel.this.conector_en_movimiento != null) {
                    if (GraphicPanel.this.puerto_en_movimiento != -1) {
                        if (GraphicPanel.this.puerto_en_movimiento == 1) {
                            GraphicPanel.this.conector_en_movimiento.setOriginAnchor(e.getX(), e.getY());
                        } else if (GraphicPanel.this.puerto_en_movimiento == 2) {
                            GraphicPanel.this.conector_en_movimiento.setEndAnchor(e.getX(), e.getY());
                        }
                    } else {
                        GraphicPanel.this.conector_en_movimiento.moveControlPoint(e.getX(), e.getY());
                    }
                    GraphicPanel.this.repaint();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                GraphicPanel.this.eliminarGrupoActivo();
                if (e.getButton() == 1 && GraphicPanel.this.designMode) {
                    if (GraphicPanel.this.dibujando_conector) {
                        GraphicPanel.this.dibujando_conector = false;
                        GraphicPanel.this.repaint();
                    }
                } else if (e.isPopupTrigger()) {
                    if (GraphicPanel.this.designMode) {
                        int traza_conector = -1;
                        int i = 0;
                        Connector c = null;
                        while (i < GraphicPanel.this.vector_conectores.size() && traza_conector == -1) {
                            c = (Connector)GraphicPanel.this.vector_conectores.get(i);
                            traza_conector = c.isOnSegment(e.getX(), e.getY());
                            ++i;
                        }
                        if (traza_conector == -1) {
                            GraphicPanel.this.item_activar.setEnabled(false);
                            GraphicPanel.this.item_desactivar.setEnabled(true);
                            GraphicPanel.this.menu_popup_panel.show((JComponent)e.getSource(), e.getX(), e.getY());
                        } else {
                            GraphicPanel.this.item_anclar.setEnabled(false);
                            GraphicPanel.this.item_quitar_anclaje.setEnabled(false);
                            int zona_anclaje = c.isOnAnchor(e.getX(), e.getY());
                            if (zona_anclaje != -1) {
                                if (zona_anclaje == 1) {
                                    if (c.hasOriginAnchor()) {
                                        GraphicPanel.this.item_quitar_anclaje.setEnabled(true);
                                    } else {
                                        GraphicPanel.this.item_anclar.setEnabled(true);
                                    }
                                } else if (c.hasEndAnchor()) {
                                    GraphicPanel.this.item_quitar_anclaje.setEnabled(true);
                                } else {
                                    GraphicPanel.this.item_anclar.setEnabled(true);
                                }
                            }
                            GraphicPanel.this.zona_anclaje_actual = zona_anclaje;
                            GraphicPanel.this.conector_actual = c;
                            GraphicPanel.this.traza_conector_actual = traza_conector;
                            GraphicPanel.this.x_sobre_conector_actual = e.getX();
                            GraphicPanel.this.y_sobre_conector_actual = e.getY();
                            GraphicPanel.this.codo_conector_actual = c.isOnControlPoint(e.getX(), e.getY());
                            GraphicPanel.this.menu_popup_conector.show((JComponent)e.getSource(), e.getX(), e.getY());
                        }
                    } else if (GraphicPanel.this.popupMenuEnabled) {
                        GraphicPanel.this.item_activar.setEnabled(true);
                        GraphicPanel.this.item_desactivar.setEnabled(false);
                        GraphicPanel.this.menu_popup_panel.show((JComponent)e.getSource(), e.getX(), e.getY());
                    }
                }
            }

            public void mousePressed(MouseEvent e) {
                if (GraphicPanel.this.designMode) {
                    boolean estado_conector_modificado = false;
                    int i = 0;
                    while (i < GraphicPanel.this.vector_conectores.size()) {
                        int port;
                        Connector c = (Connector)GraphicPanel.this.vector_conectores.get(i);
                        int codo_seleccionado = c.isOnControlPoint(e.getX(), e.getY());
                        if (codo_seleccionado != -1) {
                            GraphicPanel.this.conector_en_movimiento = c;
                            c.initControlPointMovement(codo_seleccionado);
                            estado_conector_modificado = true;
                        }
                        if ((port = c.isOnAnchor(e.getX(), e.getY())) != -1) {
                            GraphicPanel.this.conector_en_movimiento = c;
                            GraphicPanel.this.puerto_en_movimiento = port;
                            estado_conector_modificado = true;
                        }
                        ++i;
                    }
                    if (!estado_conector_modificado) {
                        GraphicPanel.this.cuadro_seleccion = new SelectionRectangle(e.getX(), e.getY(), 0, 0);
                        GraphicPanel.this.dibujando_cuadro_seleccion = true;
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (GraphicPanel.this.dibujando_cuadro_seleccion) {
                    int i;
                    GraphicPanel.this.eliminarGrupoActivo();
                    ArrayList<GraphicElement> elementos_libres = new ArrayList<GraphicElement>();
                    boolean quedan_niveles = true;
                    int cont_niveles = 0;
                    while (quedan_niveles) {
                        List v_aux = (List)GraphicPanel.this.mapa_niveles_agrupacion.get(new Integer(cont_niveles));
                        if (v_aux != null) {
                            i = 0;
                            while (i < v_aux.size()) {
                                if (((GraphicElement)v_aux.get(i)).getGroup() == null) {
                                    elementos_libres.add((GraphicElement)v_aux.get(i));
                                }
                                ++i;
                            }
                        } else {
                            quedan_niveles = false;
                        }
                        ++cont_niveles;
                    }
                    List<GraphicElement> elementos_contenidos = GraphicPanel.this.cuadro_seleccion.containsElements(elementos_libres);
                    i = 0;
                    while (i < elementos_contenidos.size()) {
                        GraphicElement elem = elementos_contenidos.get(i);
                        GraphicPanel.this.grupo_activo.add(elem);
                        ++i;
                    }
                    GraphicPanel.this.dibujando_cuadro_seleccion = false;
                    GraphicPanel.this.cuadro_seleccion = null;
                    GraphicPanel.this.repaint();
                } else if (GraphicPanel.this.conector_en_movimiento != null) {
                    GraphicPanel.this.conector_en_movimiento.finalizeControlPointMovement();
                    GraphicPanel.this.conector_en_movimiento = null;
                    GraphicPanel.this.puerto_en_movimiento = -1;
                }
            }
        });
    }

    private void ControlMouseComponentes(JComponent c) {
        c.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (!GraphicPanel.this.dibujando_conector && GraphicPanel.this.designMode) {
                    int x = e.getX();
                    int y = e.getY();
                    JComponent comp = (JComponent)e.getSource();
                    GraphicElement elemento = GraphicPanel.this.elementoSeleccionado(comp);
                    elemento.mousePressOverElement(elemento.trasnformXCoordinate(comp, x), elemento.transformYCoordinate(comp, y));
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (!GraphicPanel.this.dibujando_conector && GraphicPanel.this.designMode) {
                    JComponent comp = (JComponent)e.getSource();
                    GraphicElement elemento = GraphicPanel.this.elementoSeleccionado(comp);
                    elemento.mouseReleasedOverElement();
                }
            }

            public void mouseExited(MouseEvent e) {
                GraphicPanel.this.setCursor(Cursor.getDefaultCursor());
            }

            public void mouseClicked(MouseEvent e) {
                if (GraphicPanel.this.designMode) {
                    JComponent comp = (JComponent)e.getSource();
                    GraphicElement elemento = GraphicPanel.this.elementoSeleccionado(comp);
                    if (!GraphicPanel.this.dibujando_conector) {
                        if (GraphicPanel.this.Crtl_presionado && e.getButton() == 1) {
                            if (elemento == GraphicPanel.this.grupo_activo) {
                                GraphicElement elem = GraphicPanel.this.elementoSeleccionadoSegundoNivel(comp);
                                GraphicPanel.this.grupo_activo.remove(elem);
                            } else {
                                GraphicPanel.this.grupo_activo.add(elemento);
                            }
                        } else if (e.getButton() == 3) {
                            GraphicElementsGroup grupo = null;
                            if (elemento instanceof GraphicElementsGroup) {
                                grupo = (GraphicElementsGroup)elemento;
                            }
                            if (grupo != null) {
                                if (grupo.size() < 2) {
                                    GraphicPanel.this.menu_operaciones_grupo.setEnabled(false);
                                } else {
                                    GraphicPanel.this.menu_operaciones_grupo.setEnabled(true);
                                }
                                if (grupo == GraphicPanel.this.grupo_activo) {
                                    GraphicPanel.this.item_hacer_persistente.setEnabled(true);
                                    GraphicPanel.this.item_deshacer_persistente.setEnabled(false);
                                } else {
                                    GraphicPanel.this.item_hacer_persistente.setEnabled(false);
                                    GraphicPanel.this.item_deshacer_persistente.setEnabled(true);
                                }
                            } else {
                                GraphicPanel.this.menu_operaciones_grupo.setEnabled(false);
                                GraphicPanel.this.item_hacer_persistente.setEnabled(false);
                                GraphicPanel.this.item_deshacer_persistente.setEnabled(false);
                            }
                            GraphicPanel.this.menu_popup.show(comp, e.getX(), e.getY());
                            GraphicPanel.this.ultimo_componente_lanzar_popup = comp;
                            GraphicPanel.this.ultimo_elemento_lanzar_popup = elemento;
                            GraphicPanel.this.repaint();
                        }
                    } else if (!GraphicPanel.this.conector_temporal.isOriginComponent(elemento.getComponent())) {
                        GraphicPanel.this.conector_temporal.setEndComponent(elemento.getComponent());
                        GraphicPanel.this.vector_conectores.add(GraphicPanel.this.conector_temporal);
                        GraphicPanel.this.dibujando_conector = false;
                        GraphicPanel.this.repaint();
                    }
                }
            }
        });
        c.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                if (!GraphicPanel.this.dibujando_conector && GraphicPanel.this.designMode) {
                    int x = e.getX();
                    int y = e.getY();
                    JComponent comp = (JComponent)e.getSource();
                    GraphicElement elemento = GraphicPanel.this.elementoSeleccionado(comp);
                    int anterior_x = comp.getX();
                    int anterior_y = comp.getY();
                    int anterior_ancho = comp.getWidth();
                    int anterior_alto = comp.getHeight();
                    elemento.mouseDraggedOverElement(elemento.trasnformXCoordinate(comp, x), elemento.transformYCoordinate(comp, y));
                }
            }

            public void mouseMoved(MouseEvent e) {
                if (!GraphicPanel.this.dibujando_conector && GraphicPanel.this.designMode) {
                    int x = e.getX();
                    int y = e.getY();
                    JComponent comp = (JComponent)e.getSource();
                    GraphicElement elemento = GraphicPanel.this.elementoSeleccionado(comp);
                    elemento.mouseMoveOverElement(elemento.trasnformXCoordinate(comp, x), elemento.transformYCoordinate(comp, y));
                }
            }
        });
    }

    private void ControlMovimientoComponentes(JComponent c) {
        c.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent arg0) {
                GraphicPanel.this.repaint();
            }

            public void componentMoved(ComponentEvent arg0) {
                GraphicPanel.this.repaint();
            }

            public void componentResized(ComponentEvent arg0) {
                GraphicPanel.this.repaint();
            }

            public void componentShown(ComponentEvent arg0) {
                GraphicPanel.this.repaint();
            }
        });
    }

    public void removeAll() {
        this.cont_id_elementos = 0;
        this.mapa_componentes = new HashMap();
        this.vector_conectores.clear();
        this.mapa_niveles_agrupacion = new HashMap();
        this.grupo_activo = new GraphicElementsGroup(this.panel, this.dg_actual);
        super.removeAll();
        this.refreshSize();
    }

    private void refreshSize() {
        Component[] components = this.getComponents();
        int x = 0;
        int y = 0;
        Component[] componentArray = components;
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            Component c = componentArray[n];
            if (c.getX() + c.getWidth() > x) {
                x = c.getX() + c.getWidth();
            }
            if (c.getY() + c.getHeight() > y) {
                y = c.getY() + c.getHeight();
            }
            ++n;
        }
        this.setPreferredSize(new Dimension(x, y));
    }

    private GraphicElement elementoSeleccionado(JComponent c) {
        GraphicElement e = this.mapa_componentes.get(c);
        GraphicElement g = e.getGroup();
        while (g != null) {
            e = g;
            g = e.getGroup();
        }
        return e;
    }

    private GraphicElement elementoSeleccionadoSegundoNivel(JComponent c) {
        GraphicElement anterior = null;
        GraphicElement e = this.mapa_componentes.get(c);
        GraphicElement g = e.getGroup();
        while (g != null) {
            anterior = e;
            e = g;
            g = e.getGroup();
        }
        return anterior;
    }

    private void eliminarGrupoActivo() {
        this.grupo_activo.removeAllElements();
    }

    private void borrarConectores(GraphicElement e) {
        ArrayList<Connector> conectores_borrar = new ArrayList<Connector>();
        int i = 0;
        while (i < this.vector_conectores.size()) {
            Connector c = this.vector_conectores.get(i);
            if (c.isEndComponent(e.getComponent()) || c.isOriginComponent(e.getComponent())) {
                conectores_borrar.add(c);
            }
            ++i;
        }
        i = 0;
        while (i < conectores_borrar.size()) {
            this.vector_conectores.remove(conectores_borrar.get(i));
            ++i;
        }
    }

    private void deshacerPersistencia(GraphicElementsGroup g) {
        ArrayList<Connector> conectores_borrar = new ArrayList<Connector>();
        int i = 0;
        while (i < this.vector_conectores.size()) {
            Connector c = this.vector_conectores.get(i);
            if (c.isEndComponent(g.getComponent()) || c.isOriginComponent(g.getComponent())) {
                conectores_borrar.add(c);
            }
            ++i;
        }
        i = 0;
        while (i < conectores_borrar.size()) {
            this.vector_conectores.remove(conectores_borrar.get(i));
            ++i;
        }
        int nivel_agrupacion = g.getAgrupationLevel();
        List<GraphicElement> v = this.mapa_niveles_agrupacion.get(new Integer(nivel_agrupacion));
        v.remove(g);
        g.removeAllElements();
    }

    public void actionPerformed(ActionEvent e) {
        DrawConnectorsFactory dcf;
        DrawConnector p;
        JMenuItem item = (JMenuItem)e.getSource();
        String action = e.getActionCommand();
        JMenu aux = (JMenu)((JPopupMenu)item.getParent()).getInvoker();
        String factory_name = aux.getText();
        String menu_name = ((JMenu)((JPopupMenu)aux.getParent()).getInvoker()).getText();
        if (menu_name == this.menu_operaciones_grupo.getText()) {
            GraphicElementsGroup g = (GraphicElementsGroup)this.ultimo_elemento_lanzar_popup;
            GroupOperationsFactory gof = this.factorias_operaciones_grupo.get(factory_name);
            GroupOperation op = gof.getOperation(action);
            g.executeOperation(op);
            this.repaint();
        }
        if (menu_name == this.menu_conectores.getText() && (p = (dcf = this.factorias_conectores.get(factory_name)).getDrawConector(action)) != null) {
            this.conector_temporal = new Connector(this.ultimo_elemento_lanzar_popup.getComponent(), this.panel, p);
            this.dibujando_conector = true;
        }
        if (menu_name == this.menu_grupos.getText()) {
            DrawGroupsFactory dgf = this.factorias_grupos.get(factory_name);
            this.dg_actual = dgf.getDrawGroup(action);
            this.grupo_activo = new GraphicElementsGroup(this, this.dg_actual);
        }
    }

    private boolean pertenece(JMenu menu, JMenuItem item) {
        int i = 0;
        while (i < menu.getItemCount()) {
            if (menu.getItem(i) == item) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void readXML(Node nodo_xml) {
        NodeList conector_list;
        NodeList element_group;
        this.removeAll();
        if (nodo_xml.getNodeType() != 9) {
            return;
        }
        Document document = (Document)nodo_xml;
        NodeList graphic_element = document.getElementsByTagName("GRAPHIC_ELEMENT");
        if (graphic_element != null) {
            int i = 0;
            while (i < graphic_element.getLength()) {
                Element graphic_elem = (Element)graphic_element.item(i);
                GraphicElement ge = new GraphicElement(this);
                ge.readXML(graphic_elem);
                this.add(ge);
                ++i;
            }
        }
        if ((element_group = document.getElementsByTagName("ELEMENT_GROUP")) != null) {
            int i = 0;
            while (i < element_group.getLength()) {
                Element elem_group = (Element)element_group.item(i);
                GraphicElementsGroup gc = new GraphicElementsGroup(this);
                gc.readXML(elem_group);
                this.add(gc);
                ++i;
            }
        }
        if ((conector_list = document.getElementsByTagName("CONECTOR")) != null) {
            int i = 0;
            while (i < conector_list.getLength()) {
                Element conector = (Element)conector_list.item(i);
                Connector c = new Connector(this);
                c.readXML(conector);
                this.vector_conectores.add(c);
                ++i;
            }
        }
    }

    public void writeXML(Document d, Element e) {
        Element root = d.createElement("GRAPHIC_PANEL");
        d.appendChild(root);
        boolean quedan_niveles = true;
        int cont_niveles = 0;
        while (quedan_niveles) {
            Vector v_aux = (Vector)this.mapa_niveles_agrupacion.get(new Integer(cont_niveles));
            if (v_aux != null) {
                int i = 0;
                while (i < v_aux.size()) {
                    ((GraphicElement)v_aux.get(i)).writeXML(d, root);
                    ++i;
                }
            } else {
                quedan_niveles = false;
            }
            ++cont_niveles;
        }
        int i = 0;
        while (i < this.vector_conectores.size()) {
            this.vector_conectores.get(i).writeXML(d, root);
            ++i;
        }
    }

    public void saveAsSVG(File f) throws FileNotFoundException, SVGGraphics2DIOException, UnsupportedEncodingException {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        Document document = domImpl.createDocument(null, "svg", null);
        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
        this.paint(svgGenerator);
        FileOutputStream file = new FileOutputStream(f);
        boolean useCSS = true;
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)file, "UTF-8");
        svgGenerator.stream(out, useCSS);
    }

    public boolean isPopupMenuEnabled() {
        return this.popupMenuEnabled;
    }

    public void setPopupMenuEnabled(boolean popupMenuEnabled) {
        this.popupMenuEnabled = popupMenuEnabled;
    }

    public boolean isDesignMode() {
        return this.designMode;
    }

    public void setDesignMode(boolean modo_dise\u00f1o) {
        this.designMode = modo_dise\u00f1o;
        if (modo_dise\u00f1o) {
            this.activateDesignMode();
        } else {
            this.activateStaticMode();
        }
    }
}

