/*
 * Decompiled with CFR 0.152.
 */
package es.urjc.escet.vido.jsd.connector.draw;

import es.urjc.escet.vido.jsd.Connector;
import es.urjc.escet.vido.jsd.Line;
import es.urjc.escet.vido.jsd.connector.draw.DrawConnector;
import es.urjc.escet.vido.jsd.connector.draw.SimpleDrawConnector;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrowDrawConnector
extends SimpleDrawConnector {
    boolean fillArrow;

    public ArrowDrawConnector(boolean fillArrow) {
        this.fillArrow = fillArrow;
    }

    @Override
    public void paintLines(Graphics2D g, List<Line> trazas) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BasicStroke stroke = new BasicStroke(1.0f);
        int i = 0;
        while (i < trazas.size()) {
            g.setColor(Color.BLUE);
            Line l = trazas.get(i);
            double x2 = l.getEndPoint().getX();
            double y2 = l.getEndPoint().getY();
            double x1 = l.getStartPoint().getX();
            double y1 = l.getStartPoint().getY();
            if (i == trazas.size() - 1) {
                double ux = (x2 - x1) / Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
                double uy = (y2 - y1) / Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
                double vx = -uy;
                double vy = ux;
                double atras_x = x2 - 10.0 * ux;
                double atras_y = y2 - 10.0 * uy;
                double perpendicular_arriba_x = atras_x + 5.0 * vx;
                double perpendicular_arriba_y = atras_y + 5.0 * vy;
                double perpendicular_abajo_x = atras_x - 5.0 * vx;
                double perpendicular_abajo_y = atras_y - 5.0 * vy;
                Stroke strk = g.getStroke();
                g.setStroke(stroke);
                g.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
                if (this.fillArrow) {
                    Polygon p = new Polygon();
                    p.addPoint((int)perpendicular_arriba_x, (int)perpendicular_arriba_y);
                    p.addPoint((int)x2, (int)y2);
                    p.addPoint((int)perpendicular_abajo_x, (int)perpendicular_abajo_y);
                    g.fillPolygon(p);
                } else {
                    g.drawLine((int)perpendicular_arriba_x, (int)perpendicular_arriba_y, (int)x2, (int)y2);
                    g.drawLine((int)perpendicular_abajo_x, (int)perpendicular_abajo_y, (int)x2, (int)y2);
                }
                g.setStroke(strk);
            } else {
                Stroke strk = g.getStroke();
                g.setStroke(stroke);
                g.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
                g.setStroke(strk);
            }
            ++i;
        }
    }

    @Override
    public void paintPort(Graphics2D g, Point2D port, Connector c, DrawConnector.AnchorSide side) {
        if (side == DrawConnector.AnchorSide.ORIGIN) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(Color.BLUE);
            g.fillOval((int)port.getX() - 2, (int)port.getY() - 2, 6, 6);
        }
    }
}

