/*
 * Decompiled with CFR 0.152.
 */
package es.urjc.escet.vido.jsd.connector.draw;

import es.urjc.escet.vido.jsd.Line;
import es.urjc.escet.vido.jsd.XMLPersistent;
import es.urjc.escet.vido.jsd.connector.draw.SimpleDrawConnector;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelDrawConnector
extends SimpleDrawConnector
implements XMLPersistent {
    private String etiqueta = "";
    final String NAME = "LABEL";
    final String VALUE = "VALUE";
    final String PARAMETER = "PARAMETER";
    final String LABEL = "LABEL";

    public String getEtiqueta() {
        return this.etiqueta;
    }

    public void setEtiqueta(String etiqueta) {
        this.etiqueta = etiqueta;
    }

    @Override
    public void paintLines(Graphics2D g, List<Line> trazas) {
        g.setColor(Color.BLUE);
        int i = 0;
        while (i < trazas.size()) {
            Line t = trazas.get(i);
            Line2D.Double linea = new Line2D.Double(t.getStartPoint(), t.getEndPoint());
            g.draw(linea);
            if (i == 0) {
                g.drawString(this.etiqueta, (int)(t.getStartPoint().getX() + t.getEndPoint().getX()) / 2, (int)((t.getStartPoint().getY() + t.getEndPoint().getY()) / 2.0) + 10);
            }
            ++i;
        }
    }

    @Override
    public void readXML(Node nodo_xml) {
        if (nodo_xml.getNodeType() != 1) {
            return;
        }
        Element elem = (Element)nodo_xml;
        Element parameter = (Element)elem.getElementsByTagName("PARAMETER").item(0);
        String parameter_name = parameter.getAttribute("LABEL");
        if (parameter_name.equals("LABEL")) {
            this.etiqueta = parameter.getAttribute("VALUE");
        }
    }

    @Override
    public void writeXML(Document d, Element e) {
        Element parameter = d.createElement("PARAMETER");
        e.appendChild(parameter);
        parameter.setAttribute("LABEL", "LABEL");
        parameter.setAttribute("VALUE", this.etiqueta);
    }
}

