/*
 * Decompiled with CFR 0.152.
 */
package es.urjc.escet.vido.jsd.uml.components;

import es.urjc.escet.vido.jsd.XMLPersistent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UMLClassElement
extends JComponent
implements XMLPersistent {
    String class_name;
    String stereotype;
    final String NAME = "NAME";
    final String VALUE = "VALUE";
    final String PARAMETER = "PARAMETER";
    final String CLASS_NAME = "class_name";
    final String STEREOTYPE = "stereotype";

    public UMLClassElement() {
        this.class_name = "";
        this.stereotype = "";
    }

    public UMLClassElement(String nombre_clase, String stereotype) {
        this.class_name = nombre_clase;
        this.stereotype = stereotype;
        this.init();
    }

    private void init() {
        Font f = new Font("TimesNewRoman", 1, 30);
        FontMetrics fm = this.getFontMetrics(f);
        this.setFont(f);
        int alto = fm.getHeight() * 2 + fm.getHeight() / 3;
        int ancho_nombre = fm.stringWidth(this.class_name);
        int ancho_stereotype = fm.stringWidth("<<" + this.stereotype + ">>");
        int ancho = ancho_nombre > ancho_stereotype ? ancho_nombre : ancho_stereotype;
        int espacio_linea = alto - alto / 3;
        this.setPreferredSize(new Dimension(ancho, alto + espacio_linea));
        this.setMinimumSize(new Dimension(ancho, alto + espacio_linea));
    }

    public void paintComponent(Graphics g) {
        Color c = new Color(255, 255, 204);
        g.setColor(c);
        g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        int altura_linea = this.getHeight() - this.getHeight() / 3;
        c = new Color(153, 0, 51);
        g.setColor(c);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        g.drawLine(0, altura_linea, this.getWidth(), altura_linea);
        g.drawLine(0, altura_linea + 5, this.getWidth(), altura_linea + 5);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int x_nombre = (this.getSize().width - fm.stringWidth(this.class_name)) / 2;
        int x_stereotype = (this.getSize().width - fm.stringWidth("<<" + this.stereotype + ">>")) / 2;
        int alto = (altura_linea - 5 - fm.getHeight() * 2 + fm.getHeight() / 3) / 2;
        int y_nombre = alto - fm.getHeight() - fm.getHeight() / 3;
        int y_stereotype = alto;
        g.drawString(this.class_name, x_nombre, y_nombre + fm.getHeight() * 2 + fm.getHeight() / 3);
        g.drawString("<<" + this.stereotype + ">>", x_stereotype, y_stereotype + fm.getHeight() * 2 + fm.getHeight() / 3);
    }

    public void readXML(Node nodo_xml) {
        Element p2;
        if (nodo_xml.getNodeType() != 1) {
            return;
        }
        Element elem = (Element)nodo_xml;
        NodeList lista_parametros = elem.getElementsByTagName("PARAMETER");
        Element p1 = (Element)lista_parametros.item(0);
        if (p1.getAttribute("NAME").equals("class_name")) {
            this.class_name = p1.getAttribute("VALUE");
        }
        if ((p2 = (Element)lista_parametros.item(1)).getAttribute("NAME").equals("stereotype")) {
            this.stereotype = p2.getAttribute("VALUE");
        }
        this.init();
    }

    public void writeXML(Document d, Element e) {
        Element p1 = d.createElement("PARAMETER");
        e.appendChild(p1);
        p1.setAttribute("NAME", "class_name");
        p1.setAttribute("VALUE", this.class_name);
        Element p2 = d.createElement("PARAMETER");
        e.appendChild(p2);
        p2.setAttribute("NAME", "stereotype");
        p2.setAttribute("VALUE", this.stereotype);
    }
}

