/*
 * Decompiled with CFR 0.152.
 */
package es.urjc.escet.vido.presentation;

import es.urjc.escet.vido.jsd.XMLPersistent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Vector;
import javax.swing.JComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JTextPoint
extends JComponent
implements XMLPersistent {
    private Vector lines = new Vector();
    private final int separacion = 10;
    private Font f;
    final String NAME = "NAME";
    final String VALUE = "VALUE";
    final String PARAMETER = "PARAMETER";
    final String LINE = "LINE";
    final String MODO = "MODO";
    final String NEGRITA = "NEGRITA";
    private String modo = "";
    private boolean negrita = false;

    public JTextPoint() {
        this.modo = "grande";
    }

    public void init() {
        if (this.modo.equals("peque\u00f1o")) {
            this.f = this.negrita ? new Font("Verdana", 1, 20) : new Font("Verdana", 0, 20);
        } else if (this.modo.equals("grande")) {
            this.f = this.negrita ? new Font("Verdana", 1, 24) : new Font("Verdana", 0, 24);
        } else if (this.modo.equals("sin_punto")) {
            this.f = this.negrita ? new Font("Verdana", 1, 24) : new Font("Verdana", 0, 24);
        } else if (this.modo.equals("codigo")) {
            this.f = this.negrita ? new Font("Courier", 1, 18) : new Font("Courier", 0, 18);
        }
        FontMetrics fm = this.getFontMetrics(this.f);
        int totalAlto = this.lines.size() * (fm.getHeight() + 10);
        int anchoMayor = Integer.MIN_VALUE;
        int i = 0;
        while (i < this.lines.size()) {
            if (fm.stringWidth((String)this.lines.get(i)) > anchoMayor) {
                anchoMayor = fm.stringWidth((String)this.lines.get(i));
            }
            ++i;
        }
        this.setPreferredSize(new Dimension(anchoMayor + 20, totalAlto));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
    }

    public JTextPoint(Vector lines) {
        this.lines = (Vector)lines.clone();
        this.modo = "grande";
        this.init();
    }

    public void paintComponent(Graphics g) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Font auxf = g.getFont();
        if (this.modo.equals("peque\u00f1o")) {
            g.setColor(Color.RED);
            g.fillRect(0, 20, 10, 10);
        } else if (this.modo.equals("grande")) {
            g.setColor(Color.blue);
            g.fillRect(0, 20, 10, 10);
        }
        g.setFont(this.f);
        FontMetrics fm = this.getFontMetrics(this.f);
        g.setColor(Color.BLACK);
        int comienzoX = 20;
        int comienzoY = 30;
        int i = 0;
        while (i < this.lines.size()) {
            String line = (String)this.lines.get(i);
            g.drawString(line, comienzoX, comienzoY);
            comienzoY += fm.getHeight() + 10;
            ++i;
        }
        g.setFont(auxf);
    }

    public void addLine(String line) {
        this.lines.add(line);
    }

    public void readXML(Node nodo_xml) {
        if (nodo_xml.getNodeType() != 1) {
            return;
        }
        Element elem = (Element)nodo_xml;
        NodeList listaParametros = elem.getElementsByTagName("PARAMETER");
        int i = 0;
        while (i < listaParametros.getLength()) {
            Element p = (Element)listaParametros.item(i);
            if (p.getAttribute("NAME").equals("LINE")) {
                this.lines.add(p.getAttribute("VALUE"));
            } else if (p.getAttribute("NAME").equals("MODO")) {
                this.setModo(p.getAttribute("VALUE"));
            } else if (p.getAttribute("NAME").equals("NEGRITA") && p.getAttribute("VALUE").equals("true")) {
                this.negrita = true;
            }
            ++i;
        }
        this.init();
    }

    public void writeXML(Document d, Element e) {
        Element p = d.createElement("PARAMETER");
        e.appendChild(p);
        p.setAttribute("NAME", "MODO");
        p.setAttribute("VALUE", this.modo);
        Element p2 = d.createElement("PARAMETER");
        e.appendChild(p2);
        p2.setAttribute("NAME", "NEGRITA");
        if (this.negrita) {
            p2.setAttribute("VALUE", "true");
        } else {
            p2.setAttribute("VALUE", "false");
        }
        int i = 0;
        while (i < this.lines.size()) {
            Element p1 = d.createElement("PARAMETER");
            e.appendChild(p1);
            p1.setAttribute("NAME", "LINE");
            p1.setAttribute("VALUE", (String)this.lines.get(i));
            ++i;
        }
    }

    public String getModo() {
        return this.modo;
    }

    public void setModo(String modo) {
        this.modo = modo;
        this.init();
    }
}

