/*
 * Decompiled with CFR 0.152.
 */
package es.urjc.escet.vido.sota.gui;

import es.urjc.escet.vido.sota.gui.TextSizeAwareComponent;
import java.util.ArrayList;
import java.util.List;

public class TextSizeManager {
    int textSize;
    List<TextSizeAwareComponent> components = new ArrayList<TextSizeAwareComponent>();
    private static final int INCREMENT = 3;

    public TextSizeManager(int textSize) {
        this.textSize = textSize;
    }

    public void addComponent(TextSizeAwareComponent component) {
        component.setFontSize(this.textSize);
        this.components.add(component);
    }

    public void removeComponent(TextSizeAwareComponent component) {
        this.components.remove(component);
    }

    public void clearComponents() {
        this.components.clear();
    }

    public void incrementTextSize() {
        this.textSize += 3;
        this.refreshComponents();
    }

    public void decrementTextSize() {
        this.textSize -= 3;
        if (this.textSize < 0) {
            this.textSize = 1;
        }
        this.refreshComponents();
    }

    private void refreshComponents() {
        for (TextSizeAwareComponent component : this.components) {
            component.setFontSize(this.textSize);
        }
    }
}

