/*
 * Decompiled with CFR 0.152.
 */
package es.urjc.escet.vido.sota.symboltable;

import es.urjc.escet.vido.sota.compiler.Token;
import es.urjc.escet.vido.sota.symboltable.AbstractSymbolTable;
import es.urjc.escet.vido.sota.symboltable.AddItemLogEntry;
import es.urjc.escet.vido.sota.symboltable.CreateScopeLogEntry;
import es.urjc.escet.vido.sota.symboltable.ExitScopeLogEntry;
import es.urjc.escet.vido.sota.symboltable.FilterManager;
import es.urjc.escet.vido.sota.symboltable.Item;
import es.urjc.escet.vido.sota.symboltable.JPopupFilterMenu;
import es.urjc.escet.vido.sota.symboltable.LogEntry;
import es.urjc.escet.vido.sota.symboltable.Messages;
import es.urjc.escet.vido.sota.symboltable.SearchEvent;
import es.urjc.escet.vido.sota.symboltable.SearchListener;
import es.urjc.escet.vido.sota.symboltable.Subprogram;
import es.urjc.escet.vido.sota.symboltable.SymbolTable;
import es.urjc.escet.vido.sota.symboltable.simplest.SearchIdentifierLogEntry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LoggerSymbolTable
extends AbstractSymbolTable
implements SearchListener {
    Token actualToken;
    SymbolTable realSymbolTable;
    DefaultListModel listModel = new DefaultListModel();
    List<LogEntry> log = new ArrayList<LogEntry>();
    private boolean searchingItem;
    private boolean searchingMethod;
    private String identifierSearched;
    private JComponent component;
    private EventListenerList listenerList = new EventListenerList();
    private ChangeEvent event = new ChangeEvent(this);
    protected Token selectedToken;
    private JList list;
    private JPopupFilterMenu pm;
    private FilterManager fm = new FilterManager();
    static /* synthetic */ Class class$0;

    public LoggerSymbolTable(SymbolTable realSymbolTable) {
        this.realSymbolTable = realSymbolTable;
        this.realSymbolTable.addSearchListener(this);
        this.createJComponent();
        this.fm.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                LoggerSymbolTable.this.refreshLogList();
            }
        });
    }

    protected void refreshLogList() {
        this.listModel.clear();
        for (LogEntry e : this.log) {
            if (!this.fm.mustBeShowed(e)) continue;
            this.listModel.addElement(e);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ChangeListener.class) {
                ((ChangeListener)listeners[i + 1]).stateChanged(this.event);
            }
            i -= 2;
        }
    }

    public void setActualToken(Token actualToken) {
        this.actualToken = actualToken;
    }

    public DefaultListModel getLog() {
        return this.listModel;
    }

    public SymbolTable.AddReport addItem(Item item) {
        SymbolTable.AddReport report = this.realSymbolTable.addItem(item);
        this.addLog(new AddItemLogEntry(item, report, this.actualToken));
        return report;
    }

    private void addLog(LogEntry entry) {
        this.log.add(entry);
        if (this.fm.mustBeShowed(entry)) {
            this.listModel.addElement(entry);
        }
    }

    public void initSearchItem(String identifier) {
        this.searchingItem = true;
        this.identifierSearched = identifier;
        this.realSymbolTable.initSearchItem(identifier);
    }

    public void initSearchMethod(String identifier) {
        this.searchingMethod = true;
        this.identifierSearched = identifier;
        this.realSymbolTable.initSearchMethod(identifier);
    }

    public void initSearchMethodOrItem(String identifier) {
        this.searchingItem = true;
        this.searchingMethod = true;
        this.identifierSearched = identifier;
        this.realSymbolTable.initSearchMethodOrItem(identifier);
    }

    public void searchFinished(SearchEvent e) {
        this.addLog(new SearchIdentifierLogEntry(this.searchingItem, this.searchingMethod, this.identifierSearched, this.realSymbolTable.getItemFound(), this.realSymbolTable.getSubprogramFound(), this.actualToken));
        this.searchingItem = false;
        this.searchingMethod = false;
        this.fireSearchFinished();
    }

    public Item getItemFound() {
        return this.realSymbolTable.getItemFound();
    }

    public Subprogram getSubprogramFound() {
        return this.realSymbolTable.getSubprogramFound();
    }

    public void createScope() {
        this.addLog(new CreateScopeLogEntry(this.actualToken));
        this.realSymbolTable.createScope();
    }

    public SymbolTable.AddReport createSubprogramScope(String identifier, String returnType) {
        SymbolTable.AddReport report = this.realSymbolTable.createSubprogramScope(identifier, returnType);
        this.addLog(new CreateScopeLogEntry(identifier, returnType, report, this.actualToken));
        return report;
    }

    public void exitScope() {
        this.addLog(new ExitScopeLogEntry(this.actualToken));
        this.realSymbolTable.exitScope();
    }

    public void nextAnimationStep() {
        this.realSymbolTable.nextAnimationStep();
    }

    public boolean isOverridingSubprogramAndVariable() {
        return this.realSymbolTable.isOverridingSubprogramAndVariable();
    }

    public void setOverridingSubprogramAndVariable(boolean value) {
        this.realSymbolTable.setOverridingSubprogramAndVariable(value);
    }

    public JComponent getJComponent() {
        return this.component;
    }

    private void createJComponent() {
        JSplitPane jsp = new JSplitPane();
        JPanel stPanel = new JPanel(new BorderLayout());
        stPanel.add((Component)new JScrollPane(this.realSymbolTable.getJComponent()), "Center");
        JLabel stEtq = new JLabel(Messages.getString("LoggerSymbolTable.SymbolTable"));
        stEtq.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        stPanel.add((Component)stEtq, "North");
        jsp.setTopComponent(stPanel);
        this.list = new JList(this.listModel);
        this.list.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent e) {
                LoggerSymbolTable.this.list.scrollRectToVisible(new Rectangle(0, LoggerSymbolTable.this.list.getHeight() - 1, 1, 1));
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
            }

            public void componentHidden(ComponentEvent e) {
            }
        });
        this.list.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                label.setIcon(((LogEntry)value).getIcon());
                return label;
            }
        });
        this.list.setSelectionMode(0);
        final ListSelectionModel selectionModel = this.list.getSelectionModel();
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int index = selectionModel.getMinSelectionIndex();
                if (index != -1) {
                    LogEntry entry = (LogEntry)LoggerSymbolTable.this.listModel.elementAt(index);
                    LoggerSymbolTable.this.selectedToken = entry.getToken();
                } else {
                    LoggerSymbolTable.this.selectedToken = null;
                }
                LoggerSymbolTable.this.fireStateChanged();
            }
        });
        JPanel logPanel = new JPanel(new BorderLayout());
        JLabel etq = new JLabel(Messages.getString("LoggerSymbolTable.SymbolTableUsage"));
        etq.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel logTitlePanel = new JPanel(new BorderLayout());
        logTitlePanel.add((Component)etq, "Center");
        final JButton filters = new JButton();
        filters.setAction(new AbstractAction(Messages.getString("LoggerSymbolTable.Filters")){

            public void actionPerformed(ActionEvent e) {
                LoggerSymbolTable.this.showFilterMenu(filters);
            }
        });
        logTitlePanel.add((Component)filters, "East");
        logPanel.add((Component)logTitlePanel, "North");
        JScrollPane sp = new JScrollPane(this.list);
        logPanel.add((Component)sp, "Center");
        jsp.setBottomComponent(logPanel);
        jsp.setOrientation(0);
        jsp.setResizeWeight(0.7);
        this.component = jsp;
    }

    protected void showFilterMenu(JButton boton) {
        if (this.pm == null) {
            this.pm = new JPopupFilterMenu(this.fm);
        }
        this.pm.show(boton, 0, boton.getHeight());
    }

    public void init() {
        this.listModel.clear();
        this.log.clear();
        this.realSymbolTable.init();
    }

    public void setFontSize(int size) {
        this.list.setFont(new Font("Dialog", 0, size));
        this.realSymbolTable.setFontSize(size);
    }

    public Token getSelectedToken() {
        return this.selectedToken;
    }

    public boolean isAllowNestedIdentifiers() {
        return this.realSymbolTable.isAllowNestedIdentifiers();
    }

    public void setAllowNestedIdentifiers(boolean allowNestedIdentifiers) {
        this.realSymbolTable.setAllowNestedIdentifiers(allowNestedIdentifiers);
    }
}

