/*
 * Decompiled with CFR 0.152.
 */
import es.urjc.escet.vido.jsd.GraphicPanel;
import es.urjc.escet.vido.jsd.connector.draw.DrawConnectorsBasicFactory;
import es.urjc.escet.vido.jsd.group.draw.DrawGroupsBasicFactory;
import es.urjc.escet.vido.jsd.group.operation.GroupAligmentOperationsFactory;
import es.urjc.escet.vido.jsd.group.operation.GroupDistributionOperationsFactory;
import es.urjc.escet.vido.jsd.uml.connector.DrawConnectorsUMLFactory;
import java.awt.Color;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class VisorDiapositivas {
    private int numDiapositiva = 1;
    private GraphicPanel panel;
    private int totalDiapositivas;
    private JFrame frame;

    public VisorDiapositivas(int total_diapositivas) {
        this.totalDiapositivas = total_diapositivas;
        this.frame = new JFrame();
        this.panel = new GraphicPanel();
        this.panel.setBackground(Color.WHITE);
        JScrollPane jscroll = new JScrollPane(this.panel);
        this.frame.setContentPane(jscroll);
        this.panel.insertGroupOperationFactoy(new GroupAligmentOperationsFactory());
        this.panel.insertGroupOperationFactoy(new GroupDistributionOperationsFactory());
        this.panel.insertConnectorsFactory(new DrawConnectorsBasicFactory());
        this.panel.insertConnectorsFactory(new DrawConnectorsUMLFactory());
        this.panel.insertGroupDrawerFactory(new DrawGroupsBasicFactory());
        this.controlTeclado();
        this.iniciarAplicacion(this.frame);
        this.cargarDiapositiva();
    }

    private void iniciarAplicacion(JFrame frame) {
        frame.setTitle("Visor Diapositivas");
        frame.setDefaultCloseOperation(3);
        frame.setSize(1024, 768);
        frame.setVisible(true);
    }

    private void cargarDiapositiva() {
        this.frame.setTitle("Visor Diapostivas - diapositiva num: " + Integer.toString(this.numDiapositiva));
        String nombre_fichero = "presentacion/diapositivas/1024x768/diapositiva";
        nombre_fichero = String.valueOf(nombre_fichero) + Integer.toString(this.numDiapositiva) + ".xml";
        DocumentBuilderFactory factoria = DocumentBuilderFactory.newInstance();
        factoria.setNamespaceAware(true);
        factoria.setValidating(false);
        DocumentBuilder builder = null;
        Document document = null;
        try {
            builder = factoria.newDocumentBuilder();
            document = builder.parse(this.getClass().getClassLoader().getResourceAsStream(nombre_fichero));
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (SAXException e1) {
            e1.printStackTrace();
        }
        this.panel.readXML(document);
        this.panel.setDesignMode(false);
        this.panel.repaint();
    }

    public void anterior() {
        if (this.numDiapositiva != 1) {
            --this.numDiapositiva;
            this.cargarDiapositiva();
        }
    }

    public void siguiente() {
        if (this.numDiapositiva != this.totalDiapositivas) {
            ++this.numDiapositiva;
            this.cargarDiapositiva();
        }
    }

    private void controlTeclado() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            public boolean dispatchKeyEvent(KeyEvent e) {
                if (e.getID() == 401) {
                    if (e.getKeyCode() == 33) {
                        VisorDiapositivas.this.anterior();
                    }
                    if (e.getKeyCode() == 34) {
                        VisorDiapositivas.this.siguiente();
                    }
                }
                return false;
            }
        });
    }
}

