/*
 * Decompiled with CFR 0.152.
 */
package es.urjc.escet.vido.agui.text;

import es.urjc.escet.vido.agui.text.LeafNode;
import es.urjc.escet.vido.agui.text.Node;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.tree.TreeNode;

public class CompositeNode
extends Node {
    public CompositeNode(Object element, Document document) {
        super(document);
        this.setUserObject(element);
    }

    protected Position getOriginalStartPosition() {
        if (this.getChildCount() == 0) {
            System.out.println("No tengo hijos:" + this.getUserObject());
        }
        return ((Node)this.getFirstChild()).getStartPosition();
    }

    protected Position getOriginalEndPosition() {
        return ((Node)this.getLastChild()).getEndPosition();
    }

    public List getLeafs() {
        Vector<Node> hojas = new Vector<Node>();
        Enumeration<TreeNode> e = this.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            if (!n.isLeaf()) continue;
            hojas.add(n);
        }
        return hojas;
    }

    public Node getNodeFor(Object cf) {
        if (cf == this.getUserObject()) {
            return this;
        }
        Node n = (Node)this.getFirstChild();
        while (n != null) {
            Node aux = n.getNodeFor(cf);
            if (aux != null) {
                return aux;
            }
            n = (Node)n.getNextSibling();
        }
        return null;
    }

    public void dump() {
        List hojas = this.getLeafs();
        ListIterator it = hojas.listIterator();
        System.out.print("<");
        while (it.hasNext()) {
            LeafNode hoja = (LeafNode)it.next();
            System.out.print(String.valueOf(hoja.getStartPosition().getOffset()) + "[");
            try {
                int longitud = hoja.getLength();
                String texto = this.document.getText(hoja.getStartPosition().getOffset(), longitud);
                System.out.print(String.valueOf(texto) + "]");
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        System.out.println(">");
    }

    protected void hideOriginalContent(int parentOffset) {
        int i = this.getChildCount() - 1;
        while (i >= 0) {
            ((Node)this.getChildAt(i)).hide(parentOffset);
            --i;
        }
    }

    protected void showOriginalContent(int offset) {
        int i = this.getChildCount() - 1;
        while (i >= 0) {
            ((Node)this.getChildAt(i)).show(offset);
            --i;
        }
    }
}

