/*
 * Decompiled with CFR 0.152.
 */
package es.urjc.escet.vido.agui.text;

import es.urjc.escet.vido.agui.text.InteractiveView;
import es.urjc.escet.vido.agui.text.LeafNode;
import es.urjc.escet.vido.agui.text.Node;
import es.urjc.escet.vido.agui.text.NodeCollapsableView;
import es.urjc.escet.vido.agui.text.Paintable;
import es.urjc.escet.vido.agui.text.TextEntityFactory;
import es.urjc.escet.vido.agui.text.TextHighlighter;
import es.urjc.escet.vido.agui.text.TextPosition;
import es.urjc.escet.vido.agui.text.View;
import es.urjc.escet.vido.agui.text.event.ContextPopupMenuEvent;
import es.urjc.escet.vido.agui.text.event.ContextPopupMenuListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.tree.TreeNode;

public class JTextPaneHighlight
extends JTextPane {
    Node documentRoot;
    private boolean responsibleForContextMenu;
    boolean somethingToPaint;
    int blockStart;
    int blockEnd;
    List views = new Vector();
    List contextPopupMenuListenersList = new Vector();

    public JTextPaneHighlight() {
        this.setSelectedTextColor(Color.BLACK);
        this.setOpaque(false);
        this.setFont(new Font("Courier", 0, 14));
        this.setMargin(new Insets(0, 15, 0, 0));
        this.blockEnd = 0;
        this.blockStart = 0;
        this.somethingToPaint = false;
        this.responsibleForContextMenu = true;
        this.setHighlighter(new TextHighlighter());
    }

    protected void processMouseEvent(MouseEvent e) {
        if (e.isPopupTrigger()) {
            int offset = this.viewToModel(e.getPoint());
            this.firePopupTrigger(offset, e);
        } else {
            super.processMouseEvent(e);
        }
    }

    private void firePopupTrigger(int offset, MouseEvent e) {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setLabel("Set breakpoint");
        LeafNode leaf = this.getNodeAt(offset);
        if (leaf == null) {
            throw new Error("That position is not owned by a node");
        }
        final Object hightLighterKey = this.highlightTreeNode(leaf, new DefaultHighlighter.DefaultHighlightPainter(new Color(255, 255, 0)));
        this.processContextPopupMenuEvent(offset, leaf, popupMenu);
        if (popupMenu.getComponentCount() > 0) {
            int i = 0;
            while (i < popupMenu.getComponentCount()) {
                if (popupMenu.getComponent(i) instanceof JMenuItem) {
                    JMenuItem c = (JMenuItem)popupMenu.getComponent(i);
                    c.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            JTextPaneHighlight.this.getHighlighter().removeHighlight(hightLighterKey);
                        }
                    });
                }
                ++i;
            }
            popupMenu.show(this, e.getX(), e.getY());
        }
    }

    protected void processContextPopupMenuEvent(int offset, LeafNode leaf, JPopupMenu popupMenu) {
        if (this.contextPopupMenuListenersList.size() > 0) {
            ContextPopupMenuEvent evnt = new ContextPopupMenuEvent(popupMenu, leaf);
            int i = 0;
            while (i < this.contextPopupMenuListenersList.size()) {
                ((ContextPopupMenuListener)this.contextPopupMenuListenersList.get(i)).contextPopupMenu(evnt);
                ++i;
            }
        }
    }

    public Object highlightTreeNode(Node nodo, Highlighter.HighlightPainter dh) {
        if (!nodo.isVisible()) {
            ArrayList<View> views = new ArrayList<View>();
            views.add(nodo.getView());
            while (nodo.getParent() != null) {
                nodo = (Node)nodo.getParent();
                views.add(nodo.getView());
            }
            int i = 0;
            while (i < views.size()) {
                NodeCollapsableView v;
                if (views.get(i) != null && views.get(i) instanceof NodeCollapsableView && (v = (NodeCollapsableView)views.get(i)).isCollapsed()) {
                    v.action();
                }
                ++i;
            }
        }
        int nodeInitOffset = nodo.getStartPosition().getOffset();
        int nodeEndOffset = nodo.getEndPosition().getOffset();
        try {
            return this.getHighlighter().addHighlight(nodeInitOffset, nodeEndOffset, dh);
        }
        catch (BadLocationException e) {
            throw new Error(e);
        }
    }

    public void colapseAllNodes() {
        int i = 0;
        while (i < this.views.size()) {
            View v = (View)this.views.get(i);
            if (v instanceof InteractiveView && !((NodeCollapsableView)v).isCollapsed()) {
                ((NodeCollapsableView)v).action();
            }
            ++i;
        }
    }

    public void expandAllNodes() {
        int i = 0;
        while (i < this.views.size()) {
            View v = (View)this.views.get(i);
            if (v instanceof InteractiveView && ((NodeCollapsableView)v).isCollapsed()) {
                ((NodeCollapsableView)v).action();
            }
            ++i;
        }
    }

    public LeafNode getNodeAt(int posicion) {
        List hojas = this.documentRoot.getLeafs();
        ListIterator it = hojas.listIterator();
        while (it.hasNext()) {
            LeafNode hoja = (LeafNode)it.next();
            if (!hoja.contains(posicion)) continue;
            return hoja;
        }
        return null;
    }

    public LeafNode getNodeAt(Point p) {
        int posicion = this.viewToModel(p);
        return this.getNodeAt(posicion);
    }

    protected void paintComponent(Graphics g) {
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(0, 0, this.getInsets().left - 1, this.getHeight());
        g.setColor(Color.WHITE);
        g.fillRect(this.getInsets().left, 0, this.getWidth() - this.getInsets().left, this.getHeight());
        if (this.somethingToPaint) {
            try {
                Rectangle r1 = this.modelToView(this.blockStart);
                Rectangle r2 = r1.union(this.modelToView(this.blockEnd));
                Insets insets = this.getInsets();
                Rectangle total = new Rectangle(insets.left, r2.y, this.getWidth() - insets.left, r2.height);
                g.setColor(new Color(225, 225, 225));
                g.fillRect(total.x, total.y, total.width, total.height);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        super.paintComponent(g);
        int i = 0;
        while (i < this.views.size()) {
            if (this.views.get(i) instanceof Paintable) {
                Paintable p = (Paintable)this.views.get(i);
                p.paint(g, this);
            }
            ++i;
        }
    }

    public int getLineNonBlankStart(int posInicioBloque) {
        Element e = this.getDocument().getDefaultRootElement();
        while (e.getElementIndex(posInicioBloque) != -1) {
            e = e.getElement(e.getElementIndex(posInicioBloque));
        }
        e = e.getParentElement();
        try {
            String s = this.getText(e.getStartOffset(), e.getEndOffset() - e.getStartOffset());
            int i = 0;
            while (i < s.length() && (s.charAt(i) == ' ' || s.charAt(i) == '\t')) {
                ++i;
            }
            return e.getStartOffset() + i;
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
            throw new Error("No existe la posicion");
        }
    }

    public int getOffset(int linea, int columna) {
        Element elem = this.getDocument().getDefaultRootElement().getElement(linea - 1);
        if (elem != null) {
            return elem.getStartOffset() + columna - 1;
        }
        throw new Error("Posici\u00f3n incorrecta en el componente");
    }

    public TextPosition getLineColumnPosition(int posicion) {
        int l = 1;
        ++posicion;
        Element e = this.getDocument().getDefaultRootElement();
        Element actual = e.getElement(0);
        while (actual.getStartOffset() > posicion || actual.getEndOffset() < posicion) {
            actual = e.getElement(++l);
        }
        int col = posicion - actual.getStartOffset();
        return new TextPosition(l, col, posicion);
    }

    protected Highlighter.Highlight getHighlight(Highlighter.HighlightPainter painter) {
        Highlighter.Highlight[] highlights = this.getHighlighter().getHighlights();
        int i = 0;
        while (i < highlights.length) {
            if (highlights[i].getPainter() == painter) {
                return highlights[i];
            }
            ++i;
        }
        return null;
    }

    public Object getRepresentingObject() {
        return this.documentRoot;
    }

    public Node getRootNode() {
        return this.documentRoot;
    }

    public void setRootNode(Node root) {
        this.documentRoot = root;
    }

    protected void createPositions() {
        Enumeration<TreeNode> e = this.documentRoot.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            n.setDocument(this.getDocument());
            if (!(n instanceof LeafNode)) continue;
            ((LeafNode)n).createPositions();
        }
    }

    protected void createComponentsForInteractiveViews(TextEntityFactory factory) {
        final ImageIcon notColapsedIcon = new ImageIcon(this.getClass().getResource("menos.png"));
        final ImageIcon colapsedIcon = new ImageIcon(this.getClass().getResource("mas.png"));
        List vistas = factory.getViews();
        int i = 0;
        while (i < vistas.size()) {
            View view = (View)vistas.get(i);
            if (view instanceof NodeCollapsableView) {
                final NodeCollapsableView colapsableView = (NodeCollapsableView)view;
                final JButton boton = new JButton();
                boton.setIcon(notColapsedIcon);
                colapsableView.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        boton.setIcon(colapsableView.isCollapsed() ? colapsedIcon : notColapsedIcon);
                    }
                });
                colapsableView.setInteractiveComponent(this, boton);
            }
            ++i;
        }
        this.setViews(vistas);
    }

    public void addContextPopupMenuListener(ContextPopupMenuListener cpml) {
        this.contextPopupMenuListenersList.add(cpml);
    }

    public void removeContextPopupMenuListener(ContextPopupMenuListener cpml) {
        this.contextPopupMenuListenersList.remove(cpml);
    }

    public List getViews() {
        return this.views;
    }

    public void setViews(List list) {
        this.views = list;
    }

    public TextHighlighter getCodeHighlighter() {
        return (TextHighlighter)this.getHighlighter();
    }

    public boolean isResponsibleForContextMenu() {
        return this.responsibleForContextMenu;
    }

    public void setResponsibleForContextMenu(boolean b) {
        this.responsibleForContextMenu = b;
    }

    public Component getComponent(int arg0) {
        return super.getComponent(arg0);
    }
}

