/*
 * Decompiled with CFR 0.152.
 */
package es.urjc.escet.vido.agui.text;

import es.urjc.escet.vido.agui.text.Node;
import es.urjc.escet.vido.agui.text.NodeContent;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;

public class LeafNode
extends Node {
    int initOffset;
    int endOffset;
    boolean positionsCreated = false;
    Position inicio;
    Position fin;
    NodeContent cache;

    public LeafNode(Document document) {
        super(document);
    }

    public LeafNode(Position inicio, Document document) {
        this(document);
        this.inicio = inicio;
    }

    public LeafNode(int initOffset, int endOffset) {
        this(null);
        if (initOffset < 0 || initOffset > endOffset) {
            throw new Error("Illegal argument: offset negative or initOffset > endOffset", new IllegalArgumentException());
        }
        this.initOffset = initOffset;
        this.endOffset = endOffset;
    }

    public void createPositions() {
        try {
            this.inicio = this.document.createPosition(this.initOffset);
            this.fin = this.document.createPosition(this.endOffset);
            this.positionsCreated = true;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void setStartPosition(Position p) {
        this.inicio = p;
    }

    public void setEndPosition(Position position) {
        this.fin = position;
    }

    protected String getText() {
        String texto = null;
        try {
            texto = this.document.getText(this.getStartPosition().getOffset(), this.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return texto;
    }

    public int getLength() {
        return this.getEndPosition().getOffset() - this.getStartPosition().getOffset();
    }

    public Object getUserObject() {
        if (super.getUserObject() != null) {
            return super.getUserObject();
        }
        return ((Node)this.getParent()).getUserObject();
    }

    public boolean contains(int posicion) {
        return posicion >= this.getStartPosition().getOffset() && posicion <= this.getEndPosition().getOffset();
    }

    public List getLeafs() {
        throw new Error("Call to getHojas in a leaf");
    }

    public Node getNodeFor(Object cf) {
        if (cf == this.getUserObject()) {
            return this;
        }
        return null;
    }

    protected void hideOriginalContent(int offset) {
        String content = this.getText();
        AttributeSet attributes = ((StyledDocument)this.document).getCharacterElement(this.getStartPosition().getOffset()).getAttributes();
        this.cache = new NodeContent(content, attributes);
        this.cache.remove(this.getStartPosition().getOffset(), this.document);
    }

    protected void showOriginalContent(int offset) {
        try {
            this.fin = this.document.createPosition(offset);
            this.cache.insert(offset, this.document);
            this.inicio = this.document.createPosition(offset);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    protected Position getOriginalStartPosition() {
        return this.inicio;
    }

    protected Position getOriginalEndPosition() {
        return this.fin;
    }

    public void dump() {
        System.out.print("Soy una hoja y mi contenido es:<");
        System.out.print(this.getText());
        System.out.println(">\n");
    }

    public String toString() {
        return this.getText();
    }
}

