/*
 * Decompiled with CFR 0.152.
 */
package es.urjc.escet.vido.jsd;

import es.urjc.escet.vido.jsd.GraphicElement;
import es.urjc.escet.vido.jsd.GraphicPanel;
import es.urjc.escet.vido.jsd.Line;
import es.urjc.escet.vido.jsd.XMLPersistent;
import es.urjc.escet.vido.jsd.connector.draw.DrawConnector;
import es.urjc.escet.vido.jsd.connector.draw.SimpleDrawConnector;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Connector
implements XMLPersistent {
    final String DRAW = "DRAW";
    final String ORIGIN_ELEMENT = "INITIAL_ELEMENT";
    final String END_ELEMENT = "FINAL_ELEMENT";
    final String CODO = "CODO";
    final String X_POSITION = "X_POSITION";
    final String Y_POSITION = "Y_POSITION";
    final String CONECTOR = "CONECTOR";
    final String EXTENDED_CONFIGURATION = "EXTENDED_CONFIGURATION";
    final String INITIAL_PORT = "INITIAL_PORT";
    final String FINAL_PORT = "FINAL_PORT";
    private JComponent originComponent;
    private JComponent endComponent;
    private GraphicPanel panel;
    private boolean seleccionado = false;
    private List<Line> trazas = new ArrayList<Line>();
    private DrawConnector dibuja_trazos;
    private int codo_en_movimiento = -1;
    private boolean anclado_inicio = false;
    private boolean anclado_fin = false;
    private Point2D originAnchor = new Point2D.Double();
    private Point2D endAnchor = new Point2D.Double();

    protected Connector(JComponent conectorStartPoint, GraphicPanel panel, DrawConnector dibuja_trazos) {
        this.originComponent = conectorStartPoint;
        this.panel = panel;
        this.dibuja_trazos = dibuja_trazos;
    }

    public Connector(GraphicPanel panel, DrawConnector draw) {
        this.panel = panel;
        this.dibuja_trazos = draw;
    }

    Connector(GraphicPanel panel) {
        this.panel = panel;
    }

    protected boolean isSelected() {
        return this.seleccionado;
    }

    protected void setSelected(boolean selected) {
        this.seleccionado = selected;
        this.panel.repaint();
    }

    private void realculateLines() {
        if (this.endComponent != null) {
            int num_trazas = this.trazas.size();
            Line traza_inicial = this.trazas.get(0);
            Line traza_final = this.trazas.get(num_trazas - 1);
            Rectangle originBounds = this.getAbsoluteComponentBounds(this.originComponent);
            Rectangle endBounds = this.getAbsoluteComponentBounds(this.endComponent);
            if (!this.anclado_inicio) {
                int x_origen = (int)(originBounds.getWidth() / 2.0 + originBounds.getX());
                int y_origen = (int)(originBounds.getHeight() / 2.0 + originBounds.getY());
                Line2D.Double linea_temp1 = new Line2D.Double(x_origen, y_origen, traza_inicial.getEndPoint().getX(), traza_inicial.getEndPoint().getY());
                Point2D punto_inicial = this.calculateIntersectPoint(this.originComponent, linea_temp1);
                this.originAnchor.setLocation((punto_inicial.getX() - originBounds.getX()) * 100.0 / originBounds.getWidth(), (punto_inicial.getY() - originBounds.getY()) * 100.0 / originBounds.getHeight());
                traza_inicial.setStartPoint(punto_inicial);
            } else {
                double punto_pintado_x = this.originAnchor.getX() * originBounds.getWidth() / 100.0;
                double punto_pintado_y = this.originAnchor.getY() * originBounds.getHeight() / 100.0;
                traza_inicial.setStartPoint(new Point2D.Double(punto_pintado_x + originBounds.getX(), punto_pintado_y + originBounds.getY()));
            }
            if (!this.anclado_fin) {
                int x_destino = (int)(endBounds.getWidth() / 2.0 + (double)((int)endBounds.getX()));
                int y_destino = (int)(endBounds.getHeight() / 2.0 + (double)((int)endBounds.getY()));
                Line2D.Double linea_temp2 = new Line2D.Double(x_destino, y_destino, traza_final.getStartPoint().getX(), traza_final.getStartPoint().getY());
                Point2D punto_final = this.calculateIntersectPoint(this.endComponent, linea_temp2);
                this.endAnchor.setLocation((punto_final.getX() - endBounds.getX()) * 100.0 / endBounds.getWidth(), (punto_final.getY() - endBounds.getY()) * 100.0 / endBounds.getHeight());
                traza_final.setEndPoint(punto_final);
            } else {
                double punto_pintado_x = this.endAnchor.getX() * endBounds.getWidth() / 100.0;
                double punto_pintado_y = this.endAnchor.getY() * endBounds.getHeight() / 100.0;
                traza_final.setEndPoint(new Point2D.Double(punto_pintado_x + endBounds.getX(), punto_pintado_y + endBounds.getY()));
            }
        }
    }

    protected void paint(Graphics2D g) {
        double punto_pintado_y;
        double punto_pintado_x;
        this.realculateLines();
        if (this.anclado_fin) {
            punto_pintado_x = this.endAnchor.getX() * (double)this.endComponent.getWidth() / 100.0;
            punto_pintado_y = this.endAnchor.getY() * (double)this.endComponent.getHeight() / 100.0;
            this.dibuja_trazos.paintPort(g, new Point2D.Double(punto_pintado_x + (double)this.getAbsoluteComponentBounds((JComponent)this.endComponent).x, punto_pintado_y + (double)this.getAbsoluteComponentBounds((JComponent)this.endComponent).y), this, DrawConnector.AnchorSide.END);
        }
        if (this.anclado_inicio) {
            punto_pintado_x = this.originAnchor.getX() * (double)this.originComponent.getWidth() / 100.0;
            punto_pintado_y = this.originAnchor.getY() * (double)this.originComponent.getHeight() / 100.0;
            this.dibuja_trazos.paintPort(g, new Point2D.Double(punto_pintado_x + (double)this.getAbsoluteComponentBounds((JComponent)this.originComponent).x, punto_pintado_y + (double)this.getAbsoluteComponentBounds((JComponent)this.originComponent).y), this, DrawConnector.AnchorSide.ORIGIN);
        }
        this.dibuja_trazos.paintLines(g, this.trazas);
        this.dibuja_trazos.paintControlPoints(g, this.trazas);
    }

    protected void initControlPointMovement(int codo) {
        this.codo_en_movimiento = codo;
    }

    protected void moveControlPoint(int x, int y) {
        if (this.codo_en_movimiento != -1) {
            Line t1 = this.trazas.get(this.codo_en_movimiento - 1);
            Line t2 = this.trazas.get(this.codo_en_movimiento);
            t1.setEndPoint(new Point2D.Double(x, y));
            t2.setStartPoint(new Point2D.Double(x, y));
        }
    }

    public void moveControlPoint(int x, int y, int control_point) {
        if (this.getNumSegments() > control_point) {
            Line t1 = this.trazas.get(control_point - 1);
            Line t2 = this.trazas.get(control_point);
            t1.setEndPoint(new Point2D.Double(x, y));
            t2.setStartPoint(new Point2D.Double(x, y));
        }
    }

    protected void finalizeControlPointMovement() {
        this.codo_en_movimiento = -1;
    }

    protected void tempCoordinates(int x, int y) {
        this.trazas.clear();
        int x_origen = this.originComponent.getWidth() / 2 + this.originComponent.getX();
        int y_origen = this.originComponent.getHeight() / 2 + this.originComponent.getY();
        Line2D.Double linea_temp1 = new Line2D.Double(x_origen, y_origen, x, y);
        Point2D punto_inicial = this.calculateIntersectPoint(this.originComponent, linea_temp1);
        Point2D.Double punto_final = new Point2D.Double(x, y);
        this.trazas.add(new Line(punto_inicial, punto_final));
    }

    public boolean isOriginComponent(JComponent e) {
        return e == this.originComponent;
    }

    public boolean isEndComponent(JComponent e) {
        return e == this.endComponent;
    }

    public void setOriginComponent(JComponent e) {
        this.originComponent = e;
    }

    public void setEndComponent(JComponent e) {
        this.endComponent = e;
        Rectangle originBounds = this.getAbsoluteComponentBounds(this.originComponent);
        Rectangle endBounds = this.getAbsoluteComponentBounds(this.endComponent);
        int x_origen = (int)(originBounds.getWidth() / 2.0 + originBounds.getX());
        int y_origen = (int)(originBounds.getHeight() / 2.0 + originBounds.getY());
        int x_destino = (int)(endBounds.getWidth() / 2.0 + endBounds.getX());
        int y_destino = (int)(endBounds.getHeight() / 2.0 + endBounds.getY());
        Line2D.Double linea_temp1 = new Line2D.Double(x_origen, y_origen, x_destino, y_destino);
        Line2D.Double linea_temp2 = new Line2D.Double(x_destino, y_destino, x_origen, y_origen);
        Point2D punto_inicial = this.calculateIntersectPoint(this.originComponent, linea_temp1);
        Point2D punto_final = this.calculateIntersectPoint(this.endComponent, linea_temp2);
        this.trazas.clear();
        this.trazas.add(new Line(punto_inicial, punto_final));
    }

    public void setControlPoint(int x, int y, int num_line) {
        Line t = this.trazas.get(num_line);
        Line primera_traza = new Line(t.getStartPoint(), new Point2D.Double(x, y));
        Line segunda_traza = new Line(new Point2D.Double(x, y), t.getStartPoint());
        this.trazas.remove(t);
        this.trazas.add(num_line, primera_traza);
        this.trazas.add(num_line + 1, segunda_traza);
    }

    public void removeControlPoint(int control_point) {
        Line t_anterior = this.trazas.get(control_point - 1);
        Line t_siguiente = this.trazas.get(control_point);
        t_anterior.setEndPoint(t_siguiente.getEndPoint());
        this.trazas.remove(t_siguiente);
    }

    public int getNumSegments() {
        return this.trazas.size();
    }

    protected int isOnAnchor(int x, int y) {
        Line t = this.trazas.get(0);
        Rectangle r = new Rectangle((int)t.getStartPoint().getX() - 5, (int)t.getStartPoint().getY() - 5, 10, 10);
        if (r.contains(x, y)) {
            return 1;
        }
        t = this.trazas.get(this.trazas.size() - 1);
        r = new Rectangle((int)t.getEndPoint().getX() - 5, (int)t.getEndPoint().getY() - 5, 10, 10);
        if (r.contains(x, y)) {
            return 2;
        }
        return -1;
    }

    protected int isOnSegment(int x, int y) {
        int i = 0;
        boolean sobre_conector = false;
        while (i < this.trazas.size() && !sobre_conector) {
            Line t = this.trazas.get(i);
            sobre_conector = t.isPointOverLine(x, y);
            ++i;
        }
        if (sobre_conector) {
            return i - 1;
        }
        return -1;
    }

    protected int isOnControlPoint(int x, int y) {
        int i = 0;
        while (i < this.trazas.size()) {
            Rectangle r;
            Line t = this.trazas.get(i);
            if (i > 0 && (r = new Rectangle((int)t.getStartPoint().getX() - 5, (int)t.getStartPoint().getY() - 5, 10, 10)).contains(x, y)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private Point2D calculateIntersectPoint(JComponent e, Line2D.Double l) {
        double destino_x = l.x2;
        double destino_y = l.y2;
        Rectangle bounds = this.getAbsoluteComponentBounds(e);
        int centro_componente_x = bounds.width / 2 + bounds.x;
        int centro_componente_y = bounds.height / 2 + bounds.y;
        if (destino_x >= (double)centro_componente_x && destino_y >= (double)centro_componente_y) {
            Point2D interseccion_inferior = this.downBorderIntersect(e, l);
            if (interseccion_inferior.getX() + interseccion_inferior.getY() != 0.0) {
                return interseccion_inferior;
            }
            Point2D interseccion_derecha = this.rightBorderIntersect(e, l);
            if (interseccion_derecha.getX() + interseccion_derecha.getY() != 0.0) {
                return interseccion_derecha;
            }
        }
        if (destino_x >= (double)centro_componente_x && destino_y <= (double)centro_componente_y) {
            Point2D interseccion_derecha = this.rightBorderIntersect(e, l);
            if (interseccion_derecha.getX() + interseccion_derecha.getY() != 0.0) {
                return interseccion_derecha;
            }
            Point2D interseccion_superior = this.topBorderIntersect(e, l);
            if (interseccion_superior.getX() + interseccion_superior.getY() != 0.0) {
                return interseccion_superior;
            }
        }
        if (destino_x <= (double)centro_componente_x && destino_y <= (double)centro_componente_y) {
            Point2D interseccion_superior = this.topBorderIntersect(e, l);
            if (interseccion_superior.getX() + interseccion_superior.getY() != 0.0) {
                return interseccion_superior;
            }
            Point2D interseccion_izquierda = this.leftBorderIntersect(e, l);
            if (interseccion_izquierda.getX() + interseccion_izquierda.getY() != 0.0) {
                return interseccion_izquierda;
            }
        }
        if (destino_x <= (double)centro_componente_x && destino_y >= (double)centro_componente_y) {
            Point2D interseccion_izquierda = this.leftBorderIntersect(e, l);
            if (interseccion_izquierda.getX() + interseccion_izquierda.getY() != 0.0) {
                return interseccion_izquierda;
            }
            Point2D interseccion_inferior = this.downBorderIntersect(e, l);
            if (interseccion_inferior.getX() + interseccion_inferior.getY() != 0.0) {
                return interseccion_inferior;
            }
        }
        return new Point2D.Double(0.0, 0.0);
    }

    private Rectangle getAbsoluteComponentBounds(JComponent e) {
        int altura = e.getHeight();
        int anchura = e.getWidth();
        Point origin = new Point(0, 0);
        origin = SwingUtilities.convertPoint(e, origin, this.panel);
        int x = (int)origin.getX();
        int y = (int)origin.getY();
        return new Rectangle(x, y, anchura, altura);
    }

    private Point2D downBorderIntersect(JComponent e, Line2D.Double l) {
        double destino_x = l.y2;
        double destino_y = l.x2;
        Rectangle bounds = this.getAbsoluteComponentBounds(e);
        int i = bounds.x;
        while (i < bounds.x + bounds.width) {
            double distancia = l.ptLineDist(i, bounds.y + bounds.height);
            if (distancia < 0.5) {
                return new Point2D.Double(i, bounds.y + bounds.height);
            }
            ++i;
        }
        return new Point2D.Double(0.0, 0.0);
    }

    private Point2D rightBorderIntersect(JComponent e, Line2D.Double l) {
        double destino_x = l.y2;
        double destino_y = l.x2;
        Rectangle bounds = this.getAbsoluteComponentBounds(e);
        int i = bounds.y;
        while (i < bounds.y + bounds.height) {
            double distancia = l.ptLineDist(bounds.x + bounds.width, i);
            if (distancia < 1.0) {
                return new Point2D.Double(bounds.x + bounds.width, i);
            }
            ++i;
        }
        return new Point2D.Double(0.0, 0.0);
    }

    private Point2D topBorderIntersect(JComponent e, Line2D.Double l) {
        double destino_x = l.y2;
        double destino_y = l.x2;
        Rectangle bounds = this.getAbsoluteComponentBounds(e);
        int i = bounds.x;
        while (i < bounds.x + bounds.width) {
            double distancia = l.ptLineDist(i, bounds.y);
            if (distancia < 0.5) {
                return new Point2D.Double(i, bounds.y);
            }
            ++i;
        }
        return new Point2D.Double(0.0, 0.0);
    }

    private Point2D leftBorderIntersect(JComponent e, Line2D.Double l) {
        double destino_x = l.y2;
        double destino_y = l.x2;
        Rectangle bounds = this.getAbsoluteComponentBounds(e);
        int i = bounds.y;
        while (i < bounds.y + bounds.height) {
            double distancia = l.ptLineDist(bounds.x, i);
            if (distancia < 0.5) {
                return new Point2D.Double(bounds.x, i);
            }
            ++i;
        }
        return new Point2D.Double(0.0, 0.0);
    }

    public boolean hasEndAnchor() {
        return this.anclado_fin;
    }

    protected void setEndAnchor(boolean anclado_fin) {
        this.anclado_fin = anclado_fin;
    }

    public void removeOriginAnchor() {
        this.anclado_inicio = false;
    }

    public void removeEndAnchor() {
        this.anclado_fin = false;
    }

    public void setEndAnchor(int x, int y) {
        double porcentaje_pintado_x = x * 100 / (this.endComponent.getWidth() == 0 ? 1 : this.endComponent.getWidth());
        double porcentaje_pintado_y = y * 100 / (this.endComponent.getHeight() == 0 ? 1 : this.endComponent.getHeight());
        this.endAnchor = new Point2D.Double(porcentaje_pintado_x, porcentaje_pintado_y);
        this.setEndAnchor(true);
    }

    public void setOriginAnchor(int x, int y) {
        double porcentaje_pintado_x = x * 100 / (this.originComponent.getWidth() == 0 ? 1 : this.originComponent.getWidth());
        double porcentaje_pintado_y = y * 100 / (this.originComponent.getHeight() == 0 ? 1 : this.originComponent.getHeight());
        this.originAnchor = new Point2D.Double(porcentaje_pintado_x, porcentaje_pintado_y);
        this.setOriginAnchor(true);
    }

    public boolean hasOriginAnchor() {
        return this.anclado_inicio;
    }

    protected void setOriginAnchor(boolean anclado_inicio) {
        this.anclado_inicio = anclado_inicio;
    }

    public void readXML(Node nodo_xml) {
        NodeList final_p;
        NodeList initial;
        String y_pos;
        Element y_position;
        String x_pos;
        Element x_position;
        if (nodo_xml.getNodeType() != 1) {
            return;
        }
        Element elem = (Element)nodo_xml;
        Element draw = (Element)elem.getElementsByTagName("DRAW").item(0);
        String d = draw.getChildNodes().item(0).getNodeValue();
        try {
            this.dibuja_trazos = (DrawConnector)Class.forName(d).newInstance();
        }
        catch (InstantiationException e) {
            this.dibuja_trazos = new SimpleDrawConnector();
        }
        catch (IllegalAccessException e) {
            this.dibuja_trazos = new SimpleDrawConnector();
        }
        catch (ClassNotFoundException e) {
            this.dibuja_trazos = new SimpleDrawConnector();
        }
        if (this.dibuja_trazos instanceof XMLPersistent) {
            Element draw_config = (Element)elem.getElementsByTagName("EXTENDED_CONFIGURATION").item(0);
            ((XMLPersistent)((Object)this.dibuja_trazos)).readXML(draw_config);
        }
        Element initial_element = (Element)elem.getElementsByTagName("INITIAL_ELEMENT").item(0);
        String id_elemento_inicial = initial_element.getChildNodes().item(0).getNodeValue();
        GraphicElement ge = this.panel.getGraphicElement(Integer.parseInt(id_elemento_inicial));
        this.originComponent = ge.getComponent();
        Element final_element = (Element)elem.getElementsByTagName("FINAL_ELEMENT").item(0);
        String id_elemento_final = final_element.getChildNodes().item(0).getNodeValue();
        ge = this.panel.getGraphicElement(Integer.parseInt(id_elemento_final));
        this.setEndComponent(ge.getComponent());
        NodeList codos_list = elem.getElementsByTagName("CODO");
        if (codos_list != null) {
            int i = 0;
            while (i < codos_list.getLength()) {
                Element codo = (Element)codos_list.item(i);
                x_position = (Element)codo.getElementsByTagName("X_POSITION").item(0);
                x_pos = x_position.getChildNodes().item(0).getNodeValue();
                y_position = (Element)codo.getElementsByTagName("Y_POSITION").item(0);
                y_pos = y_position.getChildNodes().item(0).getNodeValue();
                double dx = Double.parseDouble(x_pos);
                double dy = Double.parseDouble(y_pos);
                this.setControlPoint((int)dx, (int)dy, i);
                ++i;
            }
        }
        if ((initial = elem.getElementsByTagName("INITIAL_PORT")).getLength() == 1) {
            Element initial_port = (Element)elem.getElementsByTagName("INITIAL_PORT").item(0);
            x_position = (Element)initial_port.getElementsByTagName("X_POSITION").item(0);
            x_pos = x_position.getChildNodes().item(0).getNodeValue();
            y_position = (Element)initial_port.getElementsByTagName("Y_POSITION").item(0);
            y_pos = y_position.getChildNodes().item(0).getNodeValue();
            this.setOriginAnchor(true);
            this.setOriginAnchor(this.originComponent.getX() + (int)Double.parseDouble(x_pos), this.originComponent.getY() + (int)Double.parseDouble(y_pos));
        }
        if ((final_p = elem.getElementsByTagName("FINAL_PORT")).getLength() == 1) {
            Element final_port = (Element)elem.getElementsByTagName("FINAL_PORT").item(0);
            Element x_position2 = (Element)final_port.getElementsByTagName("X_POSITION").item(0);
            String x_pos2 = x_position2.getChildNodes().item(0).getNodeValue();
            Element y_position2 = (Element)final_port.getElementsByTagName("Y_POSITION").item(0);
            String y_pos2 = y_position2.getChildNodes().item(0).getNodeValue();
            this.setEndAnchor(true);
            this.setEndAnchor(this.endComponent.getX() + (int)Double.parseDouble(x_pos2), this.endComponent.getY() + (int)Double.parseDouble(y_pos2));
        }
    }

    public void writeXML(Document d, Element e) {
        Element ip_y_position;
        Element ip_x_position;
        GraphicElement originElement = this.panel.getGraphicElement(this.originComponent);
        GraphicElement endElement = this.panel.getGraphicElement(this.endComponent);
        if (originElement == null) {
            return;
        }
        int originId = originElement.getId();
        if (endElement == null) {
            return;
        }
        int endId = endElement.getId();
        Element conector = d.createElement("CONECTOR");
        e.appendChild(conector);
        Element draw = d.createElement("DRAW");
        draw.appendChild(d.createTextNode(this.dibuja_trazos.getClass().getName()));
        conector.appendChild(draw);
        if (this.dibuja_trazos instanceof XMLPersistent) {
            XMLPersistent aux = (XMLPersistent)((Object)this.dibuja_trazos);
            Element draw_configuration = d.createElement("EXTENDED_CONFIGURATION");
            aux.writeXML(d, draw_configuration);
            conector.appendChild(draw_configuration);
        }
        Element initial_element = d.createElement("INITIAL_ELEMENT");
        initial_element.appendChild(d.createTextNode(Integer.toString(originId)));
        conector.appendChild(initial_element);
        Element final_element = d.createElement("FINAL_ELEMENT");
        final_element.appendChild(d.createTextNode(Integer.toString(endId)));
        conector.appendChild(final_element);
        int i = 0;
        while (i < this.trazas.size()) {
            Line t = this.trazas.get(i);
            if (i > 0) {
                String x_pos = Double.toString(t.getStartPoint().getX());
                String y_pos = Double.toString(t.getStartPoint().getY());
                Element codo = d.createElement("CODO");
                Element x_position = d.createElement("X_POSITION");
                Element y_position = d.createElement("Y_POSITION");
                x_position.appendChild(d.createTextNode(x_pos));
                y_position.appendChild(d.createTextNode(y_pos));
                codo.appendChild(x_position);
                codo.appendChild(y_position);
                conector.appendChild(codo);
            }
            ++i;
        }
        if (this.hasOriginAnchor()) {
            Element initial_port = d.createElement("INITIAL_PORT");
            ip_x_position = d.createElement("X_POSITION");
            ip_x_position.appendChild(d.createTextNode(Double.toString(this.originAnchor.getX())));
            initial_port.appendChild(ip_x_position);
            ip_y_position = d.createElement("Y_POSITION");
            ip_y_position.appendChild(d.createTextNode(Double.toString(this.originAnchor.getY())));
            initial_port.appendChild(ip_y_position);
            conector.appendChild(initial_port);
        }
        if (this.hasEndAnchor()) {
            Element final_port = d.createElement("FINAL_PORT");
            ip_x_position = d.createElement("X_POSITION");
            ip_x_position.appendChild(d.createTextNode(Double.toString(this.endAnchor.getX())));
            final_port.appendChild(ip_x_position);
            ip_y_position = d.createElement("Y_POSITION");
            ip_y_position.appendChild(d.createTextNode(Double.toString(this.endAnchor.getY())));
            final_port.appendChild(ip_y_position);
            conector.appendChild(final_port);
        }
    }

    public JComponent getEndComponent() {
        return this.endComponent;
    }

    public JComponent getOriginComponent() {
        return this.originComponent;
    }
}

