/*
 * Decompiled with CFR 0.152.
 */
package es.urjc.escet.vido.jsd;

import es.urjc.escet.vido.jsd.GraphicElement;
import es.urjc.escet.vido.jsd.GraphicPanel;
import es.urjc.escet.vido.jsd.XMLPersistent;
import es.urjc.escet.vido.jsd.group.draw.DrawGroup;
import es.urjc.escet.vido.jsd.group.draw.SimpleDrawGroup;
import es.urjc.escet.vido.jsd.group.operation.GroupOperation;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GraphicElementsGroup
extends GraphicElement {
    final String DRAW = "DRAW";
    final String ELEMENT = "ELEMENT";
    final String ELEMENT_GROUP = "ELEMENT_GROUP";
    final String ATTR_ID = "id";
    final String EXTENDED_CONFIGURATION = "EXTENDED_CONFIGURATION";
    private List<GraphicElement> vector_elementos = new ArrayList<GraphicElement>();
    private int numero_grupo;
    private DrawGroup dibuja_grupo;
    private boolean persistent;

    protected JComponent getComponent() {
        return null;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    GraphicElementsGroup(GraphicPanel p) {
        super(p);
    }

    public GraphicElementsGroup(GraphicPanel p, DrawGroup d) {
        super(p);
        this.dibuja_grupo = d;
        this.setPersistent(false);
    }

    public int size() {
        return this.vector_elementos.size();
    }

    public boolean isEmpty() {
        return this.vector_elementos.isEmpty();
    }

    public void add(GraphicElement e) {
        this.vector_elementos.add(e);
        e.setGroup(this);
        this.panel.repaint();
    }

    public void remove(GraphicElement e) {
        this.vector_elementos.remove(e);
        e.setGroup(null);
        this.panel.repaint();
    }

    public void removeAllElements() {
        int i = 0;
        while (i < this.vector_elementos.size()) {
            GraphicElement elem = this.vector_elementos.get(i);
            elem.setGroup(null);
            ++i;
        }
        this.vector_elementos.clear();
    }

    public GraphicElement getElement(int i) {
        return this.vector_elementos.get(i);
    }

    public boolean isInGroup(GraphicElement e) {
        return this.vector_elementos.contains(e);
    }

    public void executeOperation(GroupOperation op) {
        op.executeOperation(this, this.vector_elementos);
    }

    public int getHeight() {
        if (this.isEmpty()) {
            return -1;
        }
        GraphicElement e = this.vector_elementos.get(0);
        int y_mayor = e.getY() + e.getHeight();
        int i = 1;
        while (i < this.vector_elementos.size()) {
            GraphicElement elem = this.vector_elementos.get(i);
            int y = elem.getY() + elem.getHeight();
            if (y > y_mayor) {
                y_mayor = y;
            }
            ++i;
        }
        return y_mayor - this.getY();
    }

    public int getWidth() {
        if (this.isEmpty()) {
            return -1;
        }
        GraphicElement e = this.vector_elementos.get(0);
        int x_mayor = e.getX() + e.getWidth();
        int i = 1;
        while (i < this.vector_elementos.size()) {
            GraphicElement elem = this.vector_elementos.get(i);
            int x = elem.getX() + elem.getWidth();
            if (x > x_mayor) {
                x_mayor = x;
            }
            ++i;
        }
        return x_mayor - this.getX();
    }

    public int getX() {
        if (this.isEmpty()) {
            return -1;
        }
        int x_menor = this.vector_elementos.get(0).getX();
        int i = 1;
        while (i < this.vector_elementos.size()) {
            int x = this.vector_elementos.get(i).getX();
            if (x < x_menor) {
                x_menor = x;
            }
            ++i;
        }
        return x_menor;
    }

    public int getY() {
        if (this.isEmpty()) {
            return -1;
        }
        int y_menor = this.vector_elementos.get(0).getY();
        int i = 1;
        while (i < this.vector_elementos.size()) {
            int y = this.vector_elementos.get(i).getY();
            if (y < y_menor) {
                y_menor = y;
            }
            ++i;
        }
        return y_menor;
    }

    public void move(int desp_x, int desp_y, int desp_ancho, int desp_alto) {
        int ancho_grupo = this.getWidth();
        int alto_grupo = this.getHeight();
        int origen_grupo_x = this.getX();
        int origen_grupo_y = this.getY();
        int i = 0;
        while (i < this.vector_elementos.size()) {
            GraphicElement e = this.vector_elementos.get(i);
            int nuevo_origen_x = e.getX() + desp_x;
            int nuevo_origen_y = e.getY() + desp_y;
            int nuevo_ancho = e.getWidth() * desp_ancho / ancho_grupo;
            int nuevo_alto = e.getHeight() * desp_alto / alto_grupo;
            e.move(desp_x, desp_y, nuevo_ancho, nuevo_alto);
            ++i;
        }
    }

    public void paint(Graphics2D g) {
        if (!this.isEmpty()) {
            Rectangle r = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            if (this.isPersistent()) {
                this.dibuja_grupo.paintPersistentGroup(g, r);
            } else {
                this.dibuja_grupo.paintTemporalGroup(g, r);
            }
        }
    }

    public void setBounds(int x, int y, int ancho, int alto) {
        int ancho_grupo = this.getWidth();
        int alto_grupo = this.getHeight();
        int desp_x = x - this.getX();
        int desp_y = y - this.getY();
        int desp_ancho = ancho - this.getWidth();
        int desp_alto = alto - this.getHeight();
        int i = 0;
        while (i < this.vector_elementos.size()) {
            GraphicElement e = this.vector_elementos.get(i);
            int nuevo_origen_x = e.getX() + desp_x;
            int nuevo_origen_y = e.getY() + desp_y;
            int nuevo_ancho = e.getWidth() + e.getWidth() * desp_ancho / ancho_grupo;
            int nuevo_alto = e.getHeight() + e.getHeight() * desp_alto / alto_grupo;
            e.setBounds(nuevo_origen_x, nuevo_origen_y, nuevo_ancho, nuevo_alto);
            ++i;
        }
    }

    public void setEnabled(boolean b) {
        int i = 0;
        while (i < this.vector_elementos.size()) {
            this.vector_elementos.get(i).setEnabled(b);
            ++i;
        }
    }

    public void mousePressOverElement(int x, int y) {
        this.estado = "movimiento";
        this.pos_mov_x = x;
        this.pos_mov_y = y;
    }

    public void writeXML(Document d, Element e) {
        Element element_group = d.createElement("ELEMENT_GROUP");
        element_group.setAttribute("id", Integer.toString(this.id));
        e.appendChild(element_group);
        Element draw = d.createElement("DRAW");
        draw.appendChild(d.createTextNode(this.dibuja_grupo.getClass().getName()));
        element_group.appendChild(draw);
        if (this.dibuja_grupo instanceof XMLPersistent) {
            XMLPersistent aux = (XMLPersistent)((Object)this.dibuja_grupo);
            Element draw_configuration = d.createElement("EXTENDED_CONFIGURATION");
            aux.writeXML(d, draw_configuration);
            element_group.appendChild(draw_configuration);
        }
        int i = 0;
        while (i < this.vector_elementos.size()) {
            Element aux = d.createElement("ELEMENT");
            String id_elemento = Integer.toString(this.vector_elementos.get(i).getId());
            aux.appendChild(d.createTextNode(id_elemento));
            element_group.appendChild(aux);
            ++i;
        }
    }

    public void readXML(Node nodo_xml) {
        if (nodo_xml.getNodeType() != 1) {
            return;
        }
        Element elem = (Element)nodo_xml;
        String id_graphic_elem = elem.getAttribute("id");
        this.setId(Integer.parseInt(id_graphic_elem));
        Element draw = (Element)elem.getElementsByTagName("DRAW").item(0);
        String d = draw.getChildNodes().item(0).getNodeValue();
        try {
            this.dibuja_grupo = (DrawGroup)Class.forName(d).newInstance();
        }
        catch (InstantiationException e) {
            this.dibuja_grupo = new SimpleDrawGroup();
        }
        catch (IllegalAccessException e) {
            this.dibuja_grupo = new SimpleDrawGroup();
        }
        catch (ClassNotFoundException e) {
            this.dibuja_grupo = new SimpleDrawGroup();
        }
        if (this.dibuja_grupo instanceof XMLPersistent) {
            Element draw_config = (Element)elem.getElementsByTagName("EXTENDED_CONFIGURATION").item(0);
            ((XMLPersistent)((Object)this.dibuja_grupo)).readXML(draw_config);
        }
        this.vector_elementos.clear();
        NodeList element_list = elem.getElementsByTagName("ELEMENT");
        if (element_list != null) {
            int i = 0;
            while (i < element_list.getLength()) {
                Element element = (Element)element_list.item(i);
                String id_elem = element.getChildNodes().item(0).getNodeValue();
                GraphicElement g = this.panel.getGraphicElement(Integer.parseInt(id_elem));
                g.setGroup(this);
                this.vector_elementos.add(g);
                ++i;
            }
        }
        this.setPersistent(true);
    }

    public int getAgrupationLevel() {
        int max_agrupation_level = 0;
        int i = 0;
        while (i < this.vector_elementos.size()) {
            if (this.vector_elementos.get(i).getAgrupationLevel() > max_agrupation_level) {
                max_agrupation_level = this.vector_elementos.get(i).getAgrupationLevel();
            }
            ++i;
        }
        return max_agrupation_level + 1;
    }
}

