/*
 * Decompiled with CFR 0.152.
 */
package es.urjc.escet.vido.jsd.uml.components;

import es.urjc.escet.vido.jsd.XMLPersistent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UMLElement
extends JComponent
implements XMLPersistent {
    String className;
    String stereotype;
    static final String NAME = "NAME";
    static final String VALUE = "VALUE";
    static final String PARAMETER = "PARAMETER";
    static final String CLASS_NAME = "class_name";
    static final String STEREOTYPE = "stereotype";

    public UMLElement() {
        this.className = "";
        this.stereotype = "";
    }

    public UMLElement(String nombre_clase, String stereotype) {
        this.className = nombre_clase;
        this.stereotype = stereotype;
        this.init();
    }

    private void init() {
        Font f = new Font("TimesNewRoman", 1, 14);
        FontMetrics fm = this.getFontMetrics(f);
        this.setFont(f);
        int alto = fm.getHeight() * 2 + fm.getHeight() / 3;
        int anchoNombre = fm.stringWidth(this.className);
        int anchoStereotype = fm.stringWidth("<<" + this.stereotype + ">>");
        int ancho = anchoNombre > anchoStereotype ? anchoNombre : anchoStereotype;
        int espacioLinea = alto - alto / 3;
        this.setPreferredSize(new Dimension(ancho, alto + espacioLinea));
        this.setMinimumSize(new Dimension(ancho, alto + espacioLinea));
    }

    public void paintComponent(Graphics g) {
        Color c = new Color(255, 255, 204);
        g.setColor(c);
        g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        int alturaLinea = this.getHeight() - this.getHeight() / 3;
        c = new Color(153, 0, 51);
        g.setColor(c);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        g.drawLine(0, alturaLinea, this.getWidth(), alturaLinea);
        g.drawLine(0, alturaLinea + 5, this.getWidth(), alturaLinea + 5);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int xNombre = (this.getSize().width - fm.stringWidth(this.className)) / 2;
        int xStereotype = (this.getSize().width - fm.stringWidth("<<" + this.stereotype + ">>")) / 2;
        int alto = (alturaLinea - 5 - fm.getHeight() * 2 + fm.getHeight() / 3) / 2;
        int yNombre = alto - fm.getHeight() - fm.getHeight() / 3;
        int yStereotype = alto;
        g.drawString(this.className, xNombre, yNombre + fm.getHeight() * 2 + fm.getHeight() / 3);
        g.drawString("<<" + this.stereotype + ">>", xStereotype, yStereotype + fm.getHeight() * 2 + fm.getHeight() / 3);
    }

    public void readXML(Node nodo_xml) {
        Element p2;
        if (nodo_xml.getNodeType() != 1) {
            return;
        }
        Element elem = (Element)nodo_xml;
        NodeList listaParametros = elem.getElementsByTagName(PARAMETER);
        Element p1 = (Element)listaParametros.item(0);
        if (p1.getAttribute(NAME).equals(CLASS_NAME)) {
            this.className = p1.getAttribute(VALUE);
        }
        if ((p2 = (Element)listaParametros.item(1)).getAttribute(NAME).equals(STEREOTYPE)) {
            this.stereotype = p2.getAttribute(VALUE);
        }
        this.init();
    }

    public void writeXML(Document d, Element e) {
        Element p1 = d.createElement(PARAMETER);
        e.appendChild(p1);
        p1.setAttribute(NAME, CLASS_NAME);
        p1.setAttribute(VALUE, this.className);
        Element p2 = d.createElement(PARAMETER);
        e.appendChild(p2);
        p2.setAttribute(NAME, STEREOTYPE);
        p2.setAttribute(VALUE, this.stereotype);
    }
}

