/*
 * Decompiled with CFR 0.152.
 */
package es.urjc.escet.vido.sota.graphics;

import es.urjc.escet.vido.sota.symboltable.Item;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class JScope
extends JPanel {
    private ScopeType type;
    protected JPanel parameters;
    protected JPanel variables;
    protected int rowsParameters = 0;
    protected int rowsVariables = 0;
    Map<Item, JLabel> mapParameters = new HashMap<Item, JLabel>();
    Map<Item, JLabel> mapVariables = new HashMap<Item, JLabel>();
    List<JLabel> labelsHighlighted = new ArrayList<JLabel>();
    boolean highlighted;
    final Dimension minimumSize = new Dimension(50, 20);
    private Border defaultBorder = BorderFactory.createLineBorder(Color.BLACK, 2);
    private Border highlightBorder = BorderFactory.createLineBorder(Color.RED, 2);
    private final Border BORDER_FOR_LABELS = BorderFactory.createEmptyBorder(5, 5, 5, 5);
    private boolean tachado = false;
    private Color highlightItemColor = Color.GREEN;
    private Color defaultItemColor = Color.BLACK;
    private int fontSize = 10;

    public JScope() {
        this(ScopeType.ANONYMOUS);
    }

    public JScope(ScopeType scopeType) {
        this.type = scopeType;
        this.setOpaque(false);
        this.setBorder(this.defaultBorder);
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.LIGHT_GRAY);
        this.initializeComponents();
        this.setSize(this.minimumSize);
    }

    private void initializeComponents() {
        this.parameters = new JPanel();
        this.parameters.setLayout(new GridBagLayout());
        this.parameters.setVisible(false);
        GridBagConstraints config3 = new GridBagConstraints();
        config3.gridx = 0;
        config3.gridy = 0;
        config3.weightx = 1.0;
        config3.weighty = 0.0;
        config3.fill = 2;
        this.add((Component)this.parameters, config3);
        this.variables = new JPanel();
        this.variables.setLayout(new GridBagLayout());
        this.variables.setVisible(false);
        GridBagConstraints config4 = new GridBagConstraints();
        config4.gridx = 0;
        config4.gridy = 1;
        config4.weightx = 1.0;
        config4.weighty = 1.0;
        config4.fill = 2;
        this.add((Component)this.variables, config4);
    }

    public void addItem(Item item, int fontSize) {
        JLabel label = new JLabel("(" + item.getIdentifier() + ", " + (Object)((Object)item.getNature()) + ", " + item.getType() + (item.getNature() == Item.Nature.SUBPROGRAM ? ", )" : ")"));
        label.setBorder(this.BORDER_FOR_LABELS);
        label.setFont(new Font("Monospaced", 0, fontSize));
        label.setSize(label.getPreferredSize());
        if (item.getNature() == Item.Nature.PARAMETER) {
            if (!this.parameters.isVisible()) {
                this.parameters.setVisible(true);
            }
            this.mapParameters.put(item, label);
            GridBagConstraints config1 = new GridBagConstraints();
            config1.gridx = 0;
            config1.gridy = this.rowsParameters++;
            config1.weightx = 1.0;
            config1.weighty = 1.0;
            config1.anchor = 17;
            this.parameters.add((Component)label, config1);
        } else {
            if (!this.variables.isVisible()) {
                this.variables.setVisible(true);
            }
            if (this.parameters.isVisible()) {
                this.parameters.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLACK));
            }
            this.mapVariables.put(item, label);
            GridBagConstraints config = new GridBagConstraints();
            config.gridx = 0;
            config.gridy = this.rowsVariables++;
            config.weightx = 1.0;
            config.weighty = 1.0;
            config.anchor = 17;
            this.variables.add((Component)label, config);
        }
        this.setSize(this.getPreferredSize());
        this.validate();
        this.scrollRectToVisible(this.getBounds());
    }

    public void removeVariables() {
        this.variables.setVisible(false);
        this.parameters.setBorder(null);
        this.updateSizeIfNecessary();
    }

    private void updateSizeIfNecessary() {
        Dimension preferred = this.getPreferredSize();
        if (preferred.height < this.minimumSize.height && preferred.width < this.minimumSize.width) {
            this.setSize(this.minimumSize);
        } else {
            this.setSize(preferred);
        }
    }

    public void setHighlighted(boolean b) {
        this.highlighted = b;
        if (b) {
            this.defaultBorder = this.getBorder();
            this.setBorder(this.highlightBorder);
        } else {
            this.setBorder(this.defaultBorder);
        }
        this.updateSizeIfNecessary();
        this.validate();
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void highlightItem(Item item) {
        if (this.mapParameters.containsKey(item)) {
            JLabel itemLabel = this.mapParameters.get(item);
            itemLabel.setForeground(this.highlightItemColor);
            this.labelsHighlighted.add(itemLabel);
        } else if (this.mapVariables.containsKey(item)) {
            JLabel itemLabel = this.mapVariables.get(item);
            itemLabel.setForeground(this.highlightItemColor);
            this.labelsHighlighted.add(itemLabel);
        } else {
            throw new Error("No encuentro el item");
        }
        this.updateSizeIfNecessary();
        this.validate();
    }

    public void clean() {
        if (this.highlighted) {
            this.setBorder(this.defaultBorder);
            this.highlighted = false;
        }
        for (JLabel label : this.labelsHighlighted) {
            label.setForeground(this.defaultItemColor);
        }
        this.labelsHighlighted.clear();
        this.tachado = false;
        this.updateSizeIfNecessary();
        this.validate();
        this.repaint();
    }

    public Border getDefaultBorder() {
        return this.defaultBorder;
    }

    public void setDefaultBorder(Border defaultBorder) {
        this.defaultBorder = defaultBorder;
    }

    public Border getHighlightBorder() {
        return this.highlightBorder;
    }

    public void setHighlightBorder(Border highlightBorder) {
        this.highlightBorder = highlightBorder;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.tachado) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Insets i = this.getInsets();
            Rectangle r = this.getBounds();
            g2d.setColor(Color.RED);
            g2d.setStroke(new BasicStroke(2.0f));
            g.drawLine(i.left, i.top, r.width - (i.left + i.right), r.height - (i.bottom + i.top));
        }
    }

    public boolean isTachado() {
        return this.tachado;
    }

    public void setTachado(boolean encountered) {
        this.tachado = encountered;
    }

    public Color getDefaultItemColor() {
        return this.defaultItemColor;
    }

    public void setDefaultItemColor(Color defaultItemColor) {
        this.defaultItemColor = defaultItemColor;
    }

    public Color getHighlightItemColor() {
        return this.highlightItemColor;
    }

    public void setHighlightItemColor(Color highlightItemColor) {
        this.highlightItemColor = highlightItemColor;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
        for (JLabel jlabel : this.mapParameters.values()) {
            jlabel.setFont(new Font("Monospaced", 0, fontSize));
        }
        for (JLabel jlabel : this.mapVariables.values()) {
            jlabel.setFont(new Font("Monospaced", 0, fontSize));
        }
        this.setSize(this.getPreferredSize());
        this.validate();
    }

    public JLabel getLabel(Item item) {
        if (this.mapParameters.containsKey(item)) {
            return this.mapParameters.get(item);
        }
        if (this.mapVariables.containsKey(item)) {
            return this.mapVariables.get(item);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScopeType {
        ANONYMOUS,
        SUBPROGRAM;

    }
}

