/*
 * Decompiled with CFR 0.152.
 */
package es.urjc.escet.vido.sota.gui;

import es.urjc.escet.vido.sota.compiler.ParseException;
import es.urjc.escet.vido.sota.compiler.PascalParser;
import es.urjc.escet.vido.sota.compiler.Token;
import es.urjc.escet.vido.sota.compiler.TokenMgrError;
import es.urjc.escet.vido.sota.compiler.stactions.SearchIdentifierAction;
import es.urjc.escet.vido.sota.compiler.stactions.SymbolTableAction;
import es.urjc.escet.vido.sota.gui.AnimationEngine;
import es.urjc.escet.vido.sota.gui.AnimationListener;
import es.urjc.escet.vido.sota.gui.AnimationStep;
import es.urjc.escet.vido.sota.gui.ErrorEvent;
import es.urjc.escet.vido.sota.gui.ErrorListener;
import es.urjc.escet.vido.sota.gui.ImperativeActionAC;
import es.urjc.escet.vido.sota.gui.Messages;
import es.urjc.escet.vido.sota.gui.actions.ImperativeAction;
import es.urjc.escet.vido.sota.gui.actions.ListenerAction;
import es.urjc.escet.vido.sota.gui.actions.NumericalChangeAction;
import es.urjc.escet.vido.sota.gui.actions.ToolbarModel;
import es.urjc.escet.vido.sota.symboltable.LoggerSymbolTable;
import es.urjc.escet.vido.sota.symboltable.SearchEvent;
import es.urjc.escet.vido.sota.symboltable.SearchListener;
import es.urjc.escet.vido.sota.symboltable.simplest.SimpleSymbolTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;
import javax.swing.text.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimationEngine
implements ToolbarModel,
SearchListener {
    ImperativeAction start;
    ImperativeAction pause;
    ImperativeAction stop;
    ImperativeAction nextStep;
    ImperativeAction previousStep;
    ImperativeAction animation;
    NumericalChangeAction speed;
    int animationSpeed = 50;
    List<ListenerAction> actions = new ArrayList<ListenerAction>();
    Document d;
    LoggerSymbolTable st;
    int actualAnimationStep = -1;
    PascalParser pascalParser = new PascalParser();
    EventListenerList listenerList = new EventListenerList();
    EventObject e;
    private boolean tokenProcessing = true;
    private ErrorEvent errorEvent;
    private Timer timer;
    private List<AnimationStep> animationSteps;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public AnimationEngine(Document d, LoggerSymbolTable st) {
        st.addSearchListener(this);
        this.d = d;
        this.st = st;
        ImageIcon startIcon = new ImageIcon(this.getClass().getResource("icons/button_ok.png"));
        ImageIcon stopIcon = new ImageIcon(this.getClass().getResource("icons/cancel.png"));
        ImageIcon nextStepIcon = new ImageIcon(this.getClass().getResource("icons/1rightarrow.png"));
        ImageIcon previousStepIcon = new ImageIcon(this.getClass().getResource("icons/1leftarrow.png"));
        ImageIcon pauseIcon = new ImageIcon(this.getClass().getResource("icons/pause.png"));
        ImageIcon animationIcon = new ImageIcon(this.getClass().getResource("icons/play.png"));
        this.start = new ImperativeActionAC(Messages.getString("AnimationEngine.StartCompilation"), startIcon, ImperativeAction.ExecutionMode.EVENT_THREAD, AnimationControl.START);
        this.stop = new ImperativeActionAC(Messages.getString("AnimationEngine.StopCompilation"), stopIcon, ImperativeAction.ExecutionMode.EVENT_THREAD, AnimationControl.STOP);
        this.nextStep = new ImperativeActionAC(Messages.getString("AnimationEngine.NextStep"), nextStepIcon, ImperativeAction.ExecutionMode.EVENT_THREAD, AnimationControl.NEXT_STEP);
        this.previousStep = new ImperativeActionAC(Messages.getString("AnimationEngine.PreviousStep"), previousStepIcon, ImperativeAction.ExecutionMode.EVENT_THREAD, AnimationControl.PREVIOUS_STEP);
        this.animation = new ImperativeActionAC(Messages.getString("AnimationEngine.StartAnimation"), animationIcon, ImperativeAction.ExecutionMode.EVENT_THREAD, AnimationControl.ANIMATION);
        this.pause = new ImperativeActionAC(Messages.getString("AnimationEngine.PauseAnimation"), pauseIcon, ImperativeAction.ExecutionMode.EVENT_THREAD, AnimationControl.PAUSE);
        this.speed = new NumericalChangeAction(Messages.getString("AnimationEngine.AnimationSpeed"), 0, 100, this.animationSpeed);
        this.actions.add(this.start);
        this.actions.add(this.stop);
        this.actions.add(this.previousStep);
        this.actions.add(this.nextStep);
        this.actions.add(this.pause);
        this.actions.add(this.animation);
        this.actions.add(this.speed);
        this.start.setEnabled(true);
        this.pause.setEnabled(false);
        this.stop.setEnabled(false);
        this.previousStep.setEnabled(false);
        this.nextStep.setEnabled(false);
        this.animation.setEnabled(false);
        this.speed.setEnabled(true);
        this.timer = new Timer(0, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnimationEngine.this.nextStep();
            }
        });
    }

    @Override
    public List<ListenerAction> getActions() {
        return this.actions;
    }

    @Override
    public void executeImperativeAction(ImperativeAction ea) {
        ImperativeActionAC ac = (ImperativeActionAC)ea;
        this.animationControl(ac.getAnimationControl());
    }

    @Override
    public void executeNumericalChange(NumericalChangeAction ea, int value) {
        if (ea != this.speed) {
            throw new Error();
        }
        this.setAnimationSpeed(value);
    }

    public void addAnimationListener(AnimationListener listener) {
        this.listenerList.add(AnimationListener.class, listener);
    }

    public void removeAnimationListener(AnimationListener listener) {
        this.listenerList.remove(AnimationListener.class, listener);
    }

    public void addErrorListener(ErrorListener listener) {
        this.listenerList.add(ErrorListener.class, listener);
    }

    public void removeErrorListener(ErrorListener listener) {
        this.listenerList.remove(ErrorListener.class, listener);
    }

    public void animationControl(AnimationControl animationControl) {
        switch (animationControl.ordinal()) {
            case 0: {
                this.start();
                break;
            }
            case 1: {
                this.pause();
                break;
            }
            case 2: {
                this.stop();
                break;
            }
            case 3: {
                this.nextStep();
                break;
            }
            case 4: {
                this.previousStep();
                break;
            }
            case 5: {
                this.animation();
            }
        }
    }

    private void start() {
        try {
            List<Token> tokens = this.pascalParser.parsePascal(this.d);
            this.actualAnimationStep = 0;
            this.animationSteps = this.createAnimationSteps(tokens);
            this.st.init();
            this.highLightActualToken();
            this.start.setEnabled(false);
            this.stop.setEnabled(true);
            this.nextStep.setEnabled(true);
            this.previousStep.setEnabled(false);
            this.animation.setEnabled(true);
            this.fireAnimationStarted();
        }
        catch (ParseException e) {
            this.fireErrorProduced(e.getMessage(), ErrorEvent.ErrorType.SINTACTICAL);
        }
        catch (TokenMgrError e) {
            this.fireErrorProduced(e.getMessage(), ErrorEvent.ErrorType.LEXICAL);
        }
    }

    private List<AnimationStep> createAnimationSteps(List<Token> tokens) {
        SimpleSymbolTable symbolTable = new SimpleSymbolTable();
        symbolTable.setAllowNestedIdentifiers(true);
        symbolTable.getJComponent();
        ArrayList<AnimationStep> animationSteps = new ArrayList<AnimationStep>();
        class CounterSearchListener
        implements SearchListener {
            public boolean finished;
            final /* synthetic */ AnimationEngine this$0;

            CounterSearchListener(AnimationEngine animationEngine) {
                this.this$0 = animationEngine;
                this.finished = false;
            }

            public void searchFinished(SearchEvent e) {
                this.finished = true;
            }
        }
        CounterSearchListener csl = new CounterSearchListener(this);
        symbolTable.addSearchListener(csl);
        for (Token t : tokens) {
            animationSteps.add(new AnimationStep(t));
            SymbolTableAction sta = t.getAction();
            boolean waitForSearch = false;
            if (sta instanceof SearchIdentifierAction) {
                waitForSearch = true;
                csl.finished = false;
            }
            if (sta != null) {
                sta.doAction(symbolTable);
            }
            if (!waitForSearch) continue;
            int i = 1;
            while (!csl.finished) {
                symbolTable.nextAnimationStep();
                animationSteps.add(new AnimationStep(t, i));
                ++i;
            }
        }
        return animationSteps;
    }

    private void animation() {
        this.animation.setEnabled(false);
        this.pause.setEnabled(true);
        this.nextStep.setEnabled(false);
        this.previousStep.setEnabled(false);
        this.setAnimationSpeedInTimer();
        this.timer.setInitialDelay(0);
        this.timer.start();
    }

    private void setAnimationSpeedInTimer() {
        this.timer.setDelay((100 - this.animationSpeed) * 10);
    }

    private void stop() {
        this.start.setEnabled(true);
        this.nextStep.setEnabled(false);
        this.previousStep.setEnabled(false);
        this.pause.setEnabled(false);
        this.stop.setEnabled(false);
        this.animation.setEnabled(false);
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.fireAnimationFinished();
    }

    private void pause() {
        this.animation.setEnabled(true);
        this.pause.setEnabled(false);
        this.timer.stop();
        this.checkNextAndPreviousButtons();
    }

    @Override
    public void searchFinished(SearchEvent e) {
        this.previousStep.setEnabled(true);
        this.tokenProcessing = true;
    }

    private void previousStep() {
        this.goToAnimationStep(this.actualAnimationStep - 1);
    }

    public void goToAnimationStep(int indexOfAnimationStep) {
        if (this.actualAnimationStep > indexOfAnimationStep) {
            this.goToPreviousAnimationStep(indexOfAnimationStep);
        } else if (this.actualAnimationStep < indexOfAnimationStep) {
            this.goToBeyondAnimationStep(indexOfAnimationStep);
        }
        this.highLightActualToken();
        this.checkNextAndPreviousButtons();
    }

    private void goToBeyondAnimationStep(int animationStep) {
        int i = this.actualAnimationStep + 1;
        while (i <= animationStep) {
            AnimationStep as = this.animationSteps.get(i);
            if (as.getNumberOfSearchTimes() == 0) {
                Token t = as.getToken();
                SymbolTableAction sta = t.getAction();
                if (sta != null) {
                    this.st.setActualToken(t);
                    sta.doAction(this.st);
                }
            } else {
                this.st.nextAnimationStep();
            }
            ++i;
        }
        this.actualAnimationStep = animationStep;
    }

    private void goToPreviousAnimationStep(int animationStep) {
        this.st.init();
        int i = 0;
        while (i <= animationStep) {
            AnimationStep as = this.animationSteps.get(i);
            if (as.getNumberOfSearchTimes() == 0) {
                Token t = as.getToken();
                SymbolTableAction sta = t.getAction();
                if (sta != null) {
                    this.st.setActualToken(t);
                    sta.doAction(this.st);
                }
            } else {
                this.st.nextAnimationStep();
            }
            ++i;
        }
        this.actualAnimationStep = animationStep;
    }

    private void nextStep() {
        this.goToAnimationStep(this.actualAnimationStep + 1);
    }

    public AnimationStep getActualAnimationStep() {
        return this.animationSteps.get(this.actualAnimationStep);
    }

    private void checkNextAndPreviousButtons() {
        if (!this.timer.isRunning()) {
            if (this.actualAnimationStep == 0) {
                this.previousStep.setEnabled(false);
            } else {
                this.previousStep.setEnabled(true);
            }
            if (this.actualAnimationStep == this.animationSteps.size() - 1) {
                this.nextStep.setEnabled(false);
            } else {
                this.nextStep.setEnabled(true);
            }
        }
    }

    private void highLightActualToken() {
        this.fireTokenHighLight(this.getActualAnimationStep());
    }

    private void fireTokenHighLight(AnimationStep ae) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == AnimationListener.class) {
                if (this.e == null) {
                    this.e = new EventObject(this);
                }
                ((AnimationListener)listeners[i + 1]).animationStepChanged(this.e);
            }
            i -= 2;
        }
    }

    private void fireAnimationStarted() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == AnimationListener.class) {
                if (this.e == null) {
                    this.e = new EventObject(this);
                }
                ((AnimationListener)listeners[i + 1]).compilationStarted(this.e);
            }
            i -= 2;
        }
    }

    private void fireAnimationFinished() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == AnimationListener.class) {
                if (this.e == null) {
                    this.e = new EventObject(this);
                }
                ((AnimationListener)listeners[i + 1]).compilationFinished(this.e);
            }
            i -= 2;
        }
    }

    private void fireErrorProduced(String message, ErrorEvent.ErrorType errorType) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ErrorListener.class) {
                if (this.errorEvent == null) {
                    this.errorEvent = new ErrorEvent(this, message, errorType);
                } else {
                    this.errorEvent.setError(message, errorType);
                }
                ((ErrorListener)listeners[i + 1]).errorProduced(this.errorEvent);
            }
            i -= 2;
        }
    }

    public int getAnimationSpeed() {
        return this.animationSpeed;
    }

    public void setAnimationSpeed(int animationSpeed) {
        this.animationSpeed = animationSpeed;
        this.setAnimationSpeedInTimer();
    }

    public void setDocument(Document document) {
        this.d = document;
    }

    public int getNumberOfAnimationSteps() {
        return this.animationSteps.size();
    }

    public int getIndexOfActualAnimationStep() {
        return this.actualAnimationStep;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AnimationControl {
        START,
        PAUSE,
        STOP,
        NEXT_STEP,
        PREVIOUS_STEP,
        ANIMATION;

    }
}

