/*
 * Decompiled with CFR 0.152.
 */
package es.urjc.escet.vido.sota.gui;

import es.urjc.escet.vido.sota.compiler.DocumentUtilities;
import es.urjc.escet.vido.sota.compiler.Token;
import es.urjc.escet.vido.sota.gui.AnimationEngine;
import es.urjc.escet.vido.sota.gui.AnimationListener;
import java.awt.Color;
import java.util.EventObject;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;

public class TanimCodeManager
implements AnimationListener {
    AnimationEngine animationEngine;
    DefaultHighlighter highlighter;
    Object highlightTag;
    Object loggerHighlightTag;
    JTextArea jTextArea;
    DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(new Color(200, 200, 200));
    DefaultHighlighter.DefaultHighlightPainter loggerPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.YELLOW);

    public TanimCodeManager(JTextArea textArea, AnimationEngine animationEngine) {
        this.jTextArea = textArea;
        this.animationEngine = animationEngine;
        this.animationEngine.addAnimationListener(this);
        this.highlighter = new DefaultHighlighter();
        this.jTextArea.setHighlighter(this.highlighter);
        try {
            this.highlightTag = this.highlighter.addHighlight(0, 0, this.painter);
            this.loggerHighlightTag = this.highlighter.addHighlight(0, 0, this.loggerPainter);
        }
        catch (BadLocationException e) {
            throw new Error(e);
        }
        boolean prueba = true;
        if (prueba) {
            this.jTextArea.setText("program hello(output);\nprocedure WriteResponseHeader;\nbegin\n    writeln('content-type: text/html');\nend;\nvar\nhola: integer;\nadios: integer;\nbegin\n    WriteResponseHeader;\n    writeln('<HTML>');\n    var\n      zz: integer;\n      kk: boolean;\n    begin\n      adios := hola + 333;\n    end;\n    adios := hola + 333;\n    writeln('<BIG> Hello world!!! </BIG>');\n    writeln('</BODY>');\n    writeln('</HTML>')\nend.\n");
        }
    }

    public void animationStepChanged(EventObject e) {
        this.highLightToken(this.animationEngine.getActualAnimationStep().getToken(), this.highlightTag);
    }

    public void setLogToken(Token selectedToken) {
        this.highLightToken(selectedToken, this.loggerHighlightTag);
    }

    private void highLightToken(Token token, Object tag) {
        int endOffset;
        int beginOffset;
        if (token != null) {
            beginOffset = DocumentUtilities.getBeginOffset(this.jTextArea.getDocument(), token);
            endOffset = DocumentUtilities.getEndOffset(this.jTextArea.getDocument(), token);
        } else {
            beginOffset = 0;
            endOffset = 0;
        }
        try {
            this.highlighter.changeHighlight(tag, beginOffset, endOffset);
        }
        catch (BadLocationException e1) {
            throw new Error(e1);
        }
    }

    public void compilationStarted(EventObject e) {
        this.jTextArea.setEditable(false);
    }

    public void compilationFinished(EventObject e) {
        this.jTextArea.setEditable(true);
        try {
            this.highlighter.changeHighlight(this.highlightTag, 0, 0);
            this.highlighter.changeHighlight(this.loggerHighlightTag, 0, 0);
        }
        catch (BadLocationException e1) {
            throw new Error(e1);
        }
    }
}

