/*
 * Decompiled with CFR 0.152.
 */
package es.urjc.escet.vido.sota.gui;

import es.urjc.escet.vido.sota.gui.AnimationEngine;
import es.urjc.escet.vido.sota.gui.AnimationEngineTimeLine;
import es.urjc.escet.vido.sota.gui.AnimationListener;
import es.urjc.escet.vido.sota.gui.ErrorEvent;
import es.urjc.escet.vido.sota.gui.ErrorListener;
import es.urjc.escet.vido.sota.gui.InfoDialog;
import es.urjc.escet.vido.sota.gui.JMenuTextSize;
import es.urjc.escet.vido.sota.gui.Messages;
import es.urjc.escet.vido.sota.gui.TanimCodeManager;
import es.urjc.escet.vido.sota.gui.TextSizeManager;
import es.urjc.escet.vido.sota.gui.actions.ActionsToolbar;
import es.urjc.escet.vido.sota.gui.demos.JDemoDialog;
import es.urjc.escet.vido.sota.gui.filemanager.JTextFile;
import es.urjc.escet.vido.sota.gui.filemanager.TextFileManager;
import es.urjc.escet.vido.sota.symboltable.LoggerSymbolTable;
import es.urjc.escet.vido.sota.symboltable.simplest.SimpleSymbolTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;

public class TanimFrame
extends JFrame {
    private ActionsToolbar toolbar;
    private JTextFile jTextFile;
    private AnimationEngine animationEngine;
    private TextFileManager textFileManager;
    List<Action> fileActions;
    List<Boolean> fileActionsEnables;
    Action demosAction;
    private LoggerSymbolTable loggerSymbolTable;
    private TanimCodeManager tcm;
    private AnimationEngineTimeLine timeLine;

    public TanimFrame() {
        super(Messages.getString("TanimFrame.Titulo"));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowListener(){

            public void windowOpened(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
                TanimFrame.this.salir();
            }

            public void windowClosed(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowActivated(WindowEvent e) {
            }

            public void windowDeactivated(WindowEvent e) {
            }
        });
        this.loggerSymbolTable = new LoggerSymbolTable(new SimpleSymbolTable());
        this.loggerSymbolTable.setAllowNestedIdentifiers(true);
        this.loggerSymbolTable.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TanimFrame.this.tcm.setLogToken(TanimFrame.this.loggerSymbolTable.getSelectedToken());
            }
        });
        this.textFileManager = new TextFileManager(this);
        this.jTextFile = this.textFileManager.getJTextFile();
        Document document = this.textFileManager.getDocument();
        this.textFileManager.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TanimFrame.this.animationEngine.setDocument(TanimFrame.this.textFileManager.getDocument());
            }
        });
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu(Messages.getString("TanimFrame.Archivo"));
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
        this.fileActions = this.textFileManager.getActions();
        for (Action a : this.fileActions) {
            menu.add(a);
        }
        menu.addSeparator();
        this.demosAction = new AbstractAction(Messages.getString("TanimFrame.Demos")){

            public void actionPerformed(ActionEvent e) {
                try {
                    URL url = new URL("http://vido.escet.urjc.es/sota/demos.xml");
                    JDemoDialog.selectDemo(TanimFrame.this, url, TanimFrame.this.textFileManager.getDocument());
                }
                catch (MalformedURLException e1) {
                    throw new Error(e1);
                }
            }
        };
        menu.add(this.demosAction);
        TextSizeManager tsm = new TextSizeManager(15);
        tsm.addComponent(this.jTextFile.getTextSizeAwareComponent());
        tsm.addComponent(this.loggerSymbolTable);
        menuBar.add(new JMenuTextSize(tsm));
        menu.addSeparator();
        menu.add(new AbstractAction(Messages.getString("TanimFrame.Salir")){

            public void actionPerformed(ActionEvent e) {
                TanimFrame.this.salir();
            }
        });
        this.animationEngine = new AnimationEngine(document, this.loggerSymbolTable);
        this.tcm = new TanimCodeManager(this.jTextFile.getJTextArea(), this.animationEngine);
        this.animationEngine.addErrorListener(new ErrorListener(){

            public void errorProduced(ErrorEvent e) {
                JOptionPane.showMessageDialog(TanimFrame.this, e.getMessage(), String.valueOf(Messages.getString("TanimFrame.Error")) + (Object)((Object)e.getErrorType()), 0);
            }
        });
        this.animationEngine.addAnimationListener(new AnimationListener(){

            public void animationStepChanged(EventObject e) {
            }

            public void compilationStarted(EventObject e) {
                TanimFrame.this.animationStarted();
            }

            public void compilationFinished(EventObject e) {
                TanimFrame.this.animationFinished();
            }
        });
        this.toolbar = new ActionsToolbar(this.animationEngine);
        this.timeLine = new AnimationEngineTimeLine(this.animationEngine);
        JPanel contentPane = (JPanel)this.getContentPane();
        JPanel controlPanel = new JPanel(new BorderLayout());
        controlPanel.add((Component)this.toolbar, "North");
        controlPanel.add((Component)this.timeLine, "South");
        contentPane.add((Component)controlPanel, "North");
        JSplitPane splitPane = new JSplitPane();
        contentPane.add((Component)splitPane, "Center");
        splitPane.setLeftComponent(this.jTextFile);
        splitPane.setRightComponent(this.loggerSymbolTable.getJComponent());
        splitPane.setResizeWeight(0.3);
        this.createHelpMenu(menuBar);
    }

    private void createHelpMenu(final JMenuBar menuBar) {
        JMenu menu = new JMenu(Messages.getString("TanimFrame.HelpMenu"));
        menuBar.add(menu);
        JMenuItem helpMenuItem = new JMenuItem(new AbstractAction(Messages.getString("TanimFrame.Help")){

            public void actionPerformed(ActionEvent e) {
                String url = Locale.getDefault().getLanguage().equals("es") ? "/es/urjc/escet/vido/sota/help/es/help.html" : "/es/urjc/escet/vido/sota/help/en/help.html";
                new InfoDialog(menuBar, this.getClass().getResource(url), Messages.getString("TanimFrame.TituloHelp"));
            }
        });
        menu.add(helpMenuItem);
        JMenuItem aboutMenuItem = new JMenuItem(new AbstractAction(Messages.getString("TanimFrame.About")){

            public void actionPerformed(ActionEvent e) {
                new InfoDialog(menuBar, this.getClass().getResource("/es/urjc/escet/vido/sota/about/about.html"), Messages.getString("TanimFrame.TituloAbout"));
            }
        });
        menu.add(aboutMenuItem);
    }

    protected void animationFinished() {
        Iterator<Boolean> itEnables = this.fileActionsEnables.iterator();
        Iterator<Action> itActions = this.fileActions.iterator();
        while (itEnables.hasNext()) {
            itActions.next().setEnabled(itEnables.next());
        }
        this.fileActionsEnables = null;
        this.demosAction.setEnabled(true);
        this.loggerSymbolTable.init();
    }

    protected void animationStarted() {
        this.fileActionsEnables = new ArrayList<Boolean>();
        this.demosAction.setEnabled(false);
        for (Action a : this.fileActions) {
            this.fileActionsEnables.add(a.isEnabled());
            a.setEnabled(false);
        }
    }

    protected void salir() {
        TextFileManager.Exit exit = this.textFileManager.programExit();
        if (exit == TextFileManager.Exit.OK) {
            System.exit(0);
        }
    }
}

