/*
 * Decompiled with CFR 0.152.
 */
package es.urjc.escet.vido.sota.gui.demos;

import es.urjc.escet.vido.sota.gui.demos.Demo;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DemosParser {
    public static final String DEMO = "demo";
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String URL = "url";

    public static List<Demo> loadDemosFile(URL demosURL) throws SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            DemosHandler dh = new DemosHandler();
            saxParser.parse(demosURL.toExternalForm(), (DefaultHandler)dh);
            return dh.getDemos();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return new ArrayList<Demo>();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DemosHandler
    extends DefaultHandler {
        private List<Demo> demos = new ArrayList<Demo>();
        private String name;
        private String description;
        private String url;
        private String data;

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.data = this.data == null ? new String(ch, start, length) : String.valueOf(this.data) + new String(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.data = this.data.replace('\n', ' ');
            this.data = this.data.replace('\t', ' ');
            this.data = this.data.replaceAll("(\\n|\\t| )+", " ");
            if (qName.equals(DemosParser.DEMO)) {
                try {
                    this.demos.add(new Demo(this.name, this.description, new URL(this.url)));
                }
                catch (MalformedURLException e) {
                    throw new SAXException(e);
                }
            } else if (qName.equals(DemosParser.NAME)) {
                this.name = this.data;
            } else if (qName.equals(DemosParser.DESCRIPTION)) {
                this.description = this.data;
            } else if (qName.equals(DemosParser.URL)) {
                this.url = this.data;
            }
            this.data = null;
        }

        public List<Demo> getDemos() {
            return this.demos;
        }
    }
}

