/*
 * Decompiled with CFR 0.152.
 */
package es.urjc.escet.vido.sota.gui.demos;

import es.urjc.escet.vido.agui.AToolkit;
import es.urjc.escet.vido.sota.gui.demos.Demo;
import es.urjc.escet.vido.sota.gui.demos.DemosManager;
import es.urjc.escet.vido.sota.gui.demos.Messages;
import es.urjc.escet.vido.sota.gui.demos.WaitingDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.xml.sax.SAXException;

public class JDemoDialog
extends JDialog {
    ListSelectionModel selectionModel;
    DemosManager demosManager;
    Document document;
    Component parentComponent;

    public JDemoDialog(Component parentComponent, DemosManager demosManager, Document d) {
        super(JDemoDialog.getFrameOrDialog(parentComponent));
        this.setTitle(Messages.getString("JDemoDialog.TituloDialogoDemos"));
        this.setModal(true);
        this.parentComponent = parentComponent;
        this.demosManager = demosManager;
        this.document = d;
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)new JLabel(Messages.getString("JDemoDialog.AvailableDemos")), "North");
        Vector tableData = new Vector();
        for (Demo demo : demosManager.getDemos()) {
            Vector<String> rowData = new Vector<String>();
            rowData.add(demo.getName());
            rowData.add(demo.getDescription());
            tableData.add(rowData);
        }
        Vector<String> columns = new Vector<String>();
        columns.add(Messages.getString("JDemoDialog.DemoName"));
        columns.add(Messages.getString("JDemoDialog.DemoDescription"));
        JTable table = new JTable(tableData, columns);
        table.setAutoResizeMode(0);
        table.getColumnModel().getColumn(1).setPreferredWidth(400);
        panel.add((Component)new JScrollPane(table), "Center");
        JPanel buttons = new JPanel();
        final JButton loadDemoButton = new JButton(new AbstractAction(Messages.getString("JDemoDialog.LoadDemo")){

            public void actionPerformed(ActionEvent e) {
                JDemoDialog.this.loadSelectedDemo();
            }
        });
        loadDemoButton.setEnabled(false);
        table.setSelectionMode(0);
        this.selectionModel = table.getSelectionModel();
        this.selectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                loadDemoButton.setEnabled(JDemoDialog.this.selectionModel.getMinSelectionIndex() != -1);
            }
        });
        JButton cancelButton = new JButton(new AbstractAction(Messages.getString("JDemoDialog.Cancel")){

            public void actionPerformed(ActionEvent e) {
                JDemoDialog.this.cancel();
            }
        });
        buttons.add(loadDemoButton);
        buttons.add(cancelButton);
        panel.add((Component)buttons, "South");
        this.setContentPane(panel);
        this.pack();
        AToolkit.centerInScreen(this);
        this.setVisible(true);
    }

    private static Frame getFrameOrDialog(Component parentComponent2) {
        return null;
    }

    private static Window getWindow() {
        return null;
    }

    protected void loadSelectedDemo() {
        int index = this.selectionModel.getMinSelectionIndex();
        final Demo demo = this.demosManager.getDemos().get(index);
        this.dispose();
        final WaitingDialog wd = new WaitingDialog(this.parentComponent, Messages.getString("JDemoDialog.LoadingDemos"));
        new Thread(){

            public void run() {
                try {
                    String demoContent = demo.getDemoContent();
                    SwingUtilities.invokeLater(new Runnable(this, wd, demoContent){
                        final /* synthetic */ 4 this$1;
                        private final /* synthetic */ WaitingDialog val$wd;
                        private final /* synthetic */ String val$demoContent;
                        {
                            this.this$1 = var1_1;
                            this.val$wd = waitingDialog;
                            this.val$demoContent = string;
                        }

                        public void run() {
                            this.val$wd.dispose();
                            try {
                                4.access$0(this.this$1).document.remove(0, 4.access$0(this.this$1).document.getLength());
                                4.access$0(this.this$1).document.insertString(0, this.val$demoContent, null);
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (IOException e) {
                    SwingUtilities.invokeLater(new Runnable(this, wd, e){
                        final /* synthetic */ 4 this$1;
                        private final /* synthetic */ WaitingDialog val$wd;
                        private final /* synthetic */ IOException val$e;
                        {
                            this.this$1 = var1_1;
                            this.val$wd = waitingDialog;
                            this.val$e = iOException;
                        }

                        public void run() {
                            this.val$wd.dispose();
                            JOptionPane.showMessageDialog(4.access$0(this.this$1).parentComponent, String.valueOf(Messages.getString("JDemoDialog.ErrorLoadingDemos")) + this.val$e.getMessage(), Messages.getString("JDemoDialog.Error"), 0);
                        }
                    });
                }
            }

            static /* synthetic */ JDemoDialog access$0(4 var0) {
                return var0.JDemoDialog.this;
            }
        }.start();
        wd.setVisible(true);
    }

    protected void cancel() {
        this.dispose();
    }

    public static void selectDemo(final Component parentComponent, final URL demosURL, final Document d) {
        final WaitingDialog wd = new WaitingDialog(parentComponent, Messages.getString("JDemoDialog.LoadingDemos"));
        new Thread(){

            public void run() {
                try {
                    DemosManager dm = new DemosManager(demosURL);
                    SwingUtilities.invokeLater(new Runnable(this, wd, dm, parentComponent, d){
                        final /* synthetic */ 7 this$1;
                        private final /* synthetic */ WaitingDialog val$wd;
                        private final /* synthetic */ DemosManager val$dm;
                        private final /* synthetic */ Component val$parentComponent;
                        private final /* synthetic */ Document val$d;
                        {
                            this.this$1 = var1_1;
                            this.val$wd = waitingDialog;
                            this.val$dm = demosManager;
                            this.val$parentComponent = component;
                            this.val$d = document;
                        }

                        public void run() {
                            this.val$wd.dispose();
                            if (this.val$dm.getDemos().isEmpty()) {
                                JOptionPane.showMessageDialog(this.val$parentComponent, Messages.getString("JDemoDialog.ThereArentDemos"), Messages.getString("JDemoDialog.Error"), 0);
                            } else {
                                JDemoDialog jDemoDialog = new JDemoDialog(this.val$parentComponent, this.val$dm, this.val$d);
                            }
                        }
                    });
                }
                catch (SAXException e) {
                    SwingUtilities.invokeLater(new Runnable(this, wd, parentComponent, e){
                        final /* synthetic */ 7 this$1;
                        private final /* synthetic */ WaitingDialog val$wd;
                        private final /* synthetic */ Component val$parentComponent;
                        private final /* synthetic */ SAXException val$e;
                        {
                            this.this$1 = var1_1;
                            this.val$wd = waitingDialog;
                            this.val$parentComponent = component;
                            this.val$e = sAXException;
                        }

                        public void run() {
                            this.val$wd.dispose();
                            JOptionPane.showMessageDialog(this.val$parentComponent, String.valueOf(Messages.getString("JDemoDialog.ErrorDemosXML")) + this.val$e.getMessage(), Messages.getString("JDemoDialog.Error"), 0);
                        }
                    });
                }
                catch (IOException e) {
                    SwingUtilities.invokeLater(new Runnable(this, wd, parentComponent, e){
                        final /* synthetic */ 7 this$1;
                        private final /* synthetic */ WaitingDialog val$wd;
                        private final /* synthetic */ Component val$parentComponent;
                        private final /* synthetic */ IOException val$e;
                        {
                            this.this$1 = var1_1;
                            this.val$wd = waitingDialog;
                            this.val$parentComponent = component;
                            this.val$e = iOException;
                        }

                        public void run() {
                            this.val$wd.dispose();
                            JOptionPane.showMessageDialog(this.val$parentComponent, String.valueOf(Messages.getString("JDemoDialog.ErrorLoadingDemosFile")) + this.val$e.getMessage(), Messages.getString("JDemoDialog.Error"), 0);
                        }
                    });
                }
            }
        }.start();
        wd.setVisible(true);
    }
}

