/*
 * Decompiled with CFR 0.152.
 */
package es.urjc.escet.vido.sota.gui.filemanager;

import es.urjc.escet.vido.sota.gui.TextSizeAwareComponent;
import es.urjc.escet.vido.sota.gui.filemanager.Messages;
import es.urjc.escet.vido.sota.gui.filemanager.TextFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JTextFile
extends JPanel {
    private JTextArea textArea = new JTextArea();
    private JLabel fileName;
    private TextFile textFile;

    public JTextFile(TextFile textFile) {
        super(new BorderLayout());
        this.textArea.setFont(new Font("Monospaced", 0, 15));
        this.fileName = new JLabel();
        this.fileName.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.fileName, "North");
        this.add((Component)new JScrollPane(this.textArea), "Center");
        this.setMinimumSize(new Dimension(50, 50));
        this.setTextFile(textFile);
    }

    public void setTextFile(TextFile textFile) {
        this.textFile = textFile;
        this.textFile.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JTextFile.this.refresh();
            }
        });
        this.textArea.setDocument(textFile.getDocument());
        this.refresh();
    }

    protected void refresh() {
        String text = this.textFile.isDirty() ? "* " : "";
        text = String.valueOf(text) + Messages.getString("JTextFile.Programa");
        File f = this.textFile.getFile();
        text = f == null ? String.valueOf(text) + Messages.getString("JTextFile.NoAssignedFile") : String.valueOf(text) + f.getAbsolutePath();
        this.fileName.setText(text);
    }

    public JTextArea getJTextArea() {
        return this.textArea;
    }

    public TextSizeAwareComponent getTextSizeAwareComponent() {
        return new TextSizeAwareComponent(){

            public void setFontSize(int i) {
                JTextFile.this.textArea.setFont(new Font("Monospaced", 0, i));
            }
        };
    }
}

