/*
 * Decompiled with CFR 0.152.
 */
package es.urjc.escet.vido.sota.gui.filemanager;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class TextFile {
    PlainDocument document;
    File file;
    boolean dirty = false;
    EventListenerList listenerList = new EventListenerList();
    ChangeEvent event = new ChangeEvent(this);
    static /* synthetic */ Class class$0;

    public TextFile(File file) throws IOException {
        this.file = file;
        this.setDocument(TextFile.loadFileContent(file));
    }

    public TextFile() {
        this.setDocument(new PlainDocument());
        this.dirty = true;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ChangeListener.class) {
                ((ChangeListener)listeners[i + 1]).stateChanged(this.event);
            }
            i -= 2;
        }
    }

    private void setDocument(PlainDocument document) {
        this.document = document;
        this.document.addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                TextFile.this.documentChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                TextFile.this.documentChanged();
            }

            public void changedUpdate(DocumentEvent e) {
                TextFile.this.documentChanged();
            }
        });
    }

    protected void documentChanged() {
        if (!this.dirty) {
            this.dirty = true;
            this.fireStateChanged();
        }
    }

    public void save() throws IOException {
        TextFile.saveFileContent(this.document, this.file);
        boolean oldDirty = this.dirty;
        this.dirty = false;
        if (oldDirty) {
            this.fireStateChanged();
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public static PlainDocument loadFileContent(File file) throws IOException {
        FileReader reader = new FileReader(file);
        BufferedReader bReader = new BufferedReader(reader);
        StringBuffer sb = new StringBuffer();
        char[] buffer = new char[512];
        int leidos = bReader.read(buffer);
        while (leidos != -1) {
            sb.append(buffer, 0, leidos);
            leidos = bReader.read(buffer);
        }
        ((Reader)reader).close();
        PlainDocument document = new PlainDocument();
        try {
            document.insertString(0, sb.toString(), null);
        }
        catch (BadLocationException e) {
            throw new Error(e);
        }
        return document;
    }

    public static void saveFileContent(PlainDocument document, File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        BufferedWriter bWriter = new BufferedWriter(writer);
        try {
            bWriter.append(document.getText(0, document.getLength()));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        bWriter.close();
    }

    public PlainDocument getDocument() {
        return this.document;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        File oldFile = this.file;
        this.file = file;
        if (oldFile != null && !oldFile.equals(file)) {
            this.dirty = true;
        }
        this.fireStateChanged();
    }
}

