/*
 * Decompiled with CFR 0.152.
 */
package es.urjc.escet.vido.sota.gui.filemanager;

import es.urjc.escet.vido.sota.gui.filemanager.JTextFile;
import es.urjc.escet.vido.sota.gui.filemanager.Messages;
import es.urjc.escet.vido.sota.gui.filemanager.TextFile;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFileManager {
    private TextFile textFile;
    private JTextFile jTextFile;
    private List<Action> actions;
    private Action openAction;
    private Action saveAction;
    private Action saveAsAction;
    private Action newAction;
    private Component parentComponent;
    EventListenerList listenerList = new EventListenerList();
    ChangeEvent event = new ChangeEvent(this);
    static /* synthetic */ Class class$0;

    public TextFileManager(Component parentComponent) {
        this.parentComponent = parentComponent;
        this.textFile = new TextFile();
        this.jTextFile = new JTextFile(this.textFile);
        this.openAction = new AbstractAction(Messages.getString("TextFileManager.Abrir")){

            public void actionPerformed(ActionEvent e) {
                TextFileManager.this.abrir();
            }
        };
        this.saveAction = new AbstractAction(Messages.getString("TextFileManager.Guardar")){

            public void actionPerformed(ActionEvent e) {
                TextFileManager.this.guardar();
            }
        };
        this.saveAsAction = new AbstractAction(Messages.getString("TextFileManager.GuardarComo")){

            public void actionPerformed(ActionEvent e) {
                TextFileManager.this.guardarComo();
            }
        };
        this.newAction = new AbstractAction(Messages.getString("TextFileManager.Nuevo")){

            public void actionPerformed(ActionEvent e) {
                TextFileManager.this.nuevo();
            }
        };
        this.saveAction.setEnabled(false);
        this.actions = new ArrayList<Action>();
        this.actions.add(this.newAction);
        this.actions.add(this.openAction);
        this.actions.add(this.saveAction);
        this.actions.add(this.saveAsAction);
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ChangeListener.class) {
                ((ChangeListener)listeners[i + 1]).stateChanged(this.event);
            }
            i -= 2;
        }
    }

    protected void nuevo() {
        this.saveIfNecesary();
        this.textFile = new TextFile();
        this.jTextFile.setTextFile(this.textFile);
        this.saveAction.setEnabled(false);
        this.fireStateChanged();
    }

    protected void guardarComo() {
        JFileChooser jfc = new JFileChooser();
        int option = jfc.showSaveDialog(this.parentComponent);
        if (option == 0) {
            File selectedFile = jfc.getSelectedFile();
            if (selectedFile.exists() && ((option = JOptionPane.showConfirmDialog(this.parentComponent, String.valueOf(Messages.getString("TextFileManager.ElFichero")) + selectedFile.getAbsolutePath() + Messages.getString("TextFileManager.YaExisteSobreescribirlo"))) == 1 || option == 2)) {
                return;
            }
            this.textFile.setFile(jfc.getSelectedFile());
            this.guardar();
            this.textFile.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    TextFileManager.this.saveAction.setEnabled(TextFileManager.this.textFile.isDirty());
                }
            });
        }
        this.saveAction.setEnabled(false);
    }

    protected void guardar() {
        try {
            this.textFile.save();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.parentComponent, e.getMessage(), Messages.getString("TextFileManager.Error"), 0);
        }
        this.saveAction.setEnabled(false);
    }

    protected void abrir() {
        JFileChooser jfc = new JFileChooser();
        int option = jfc.showOpenDialog(this.parentComponent);
        if (option == 0) {
            try {
                this.textFile = new TextFile(jfc.getSelectedFile());
                this.jTextFile.setTextFile(this.textFile);
                this.textFile.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent e) {
                        TextFileManager.this.saveAction.setEnabled(TextFileManager.this.textFile.isDirty());
                    }
                });
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.parentComponent, e.getMessage(), Messages.getString("TextFileManager.Error"), 0);
            }
        }
        this.fireStateChanged();
    }

    public TextFile getTextFile() {
        return this.textFile;
    }

    public void setTextFile(TextFile textFile) {
        this.textFile = textFile;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public JTextFile getJTextFile() {
        return this.jTextFile;
    }

    public Document getDocument() {
        return this.textFile.getDocument();
    }

    private Exit saveIfNecesary() {
        if (this.textFile.isDirty()) {
            int selectedOption = JOptionPane.showConfirmDialog(this.parentComponent, Messages.getString("TextFileManager.FicheroCambiadoGuardar"));
            if (selectedOption == 0) {
                if (this.textFile.getFile() == null) {
                    this.guardarComo();
                } else {
                    this.guardar();
                }
                return Exit.OK;
            }
            if (selectedOption == 1) {
                return Exit.OK;
            }
            return Exit.CANCEL;
        }
        return Exit.OK;
    }

    public Exit programExit() {
        return this.saveIfNecesary();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Exit {
        OK,
        CANCEL;

    }
}

