/*
 * Decompiled with CFR 0.152.
 */
package es.urjc.escet.vido.sota.symboltable.simplest;

import es.urjc.escet.vido.jsd.Connector;
import es.urjc.escet.vido.jsd.GraphicElement;
import es.urjc.escet.vido.jsd.GraphicPanel;
import es.urjc.escet.vido.jsd.connector.draw.ArrowDrawConnector;
import es.urjc.escet.vido.sota.graphics.JScope;
import es.urjc.escet.vido.sota.symboltable.AbstractSymbolTable;
import es.urjc.escet.vido.sota.symboltable.Item;
import es.urjc.escet.vido.sota.symboltable.Subprogram;
import es.urjc.escet.vido.sota.symboltable.SymbolTable;
import es.urjc.escet.vido.sota.symboltable.simplest.Scope;
import es.urjc.escet.vido.sota.symboltable.simplest.SubprogramScope;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class SimpleSymbolTable
extends AbstractSymbolTable {
    Scope rootNode;
    Scope actualNode;
    List<Scope> searchNodes;
    String identifierSearched;
    WhatSearched what;
    boolean allowOverrideSubprogramAndVariable = false;
    boolean allowNestedIdentifiers = false;
    GraphicPanel visualization;
    JScope jscope;
    Map<Scope, JScope> visualScopes;
    boolean cleanSearch = false;
    static Logger logger = Logger.getLogger("Sota");
    private static final int HORIZONTAL_SCOPE_SPACE = 50;
    private static final int VERTICAL_SCOPE_SPACE = 20;
    private static final Point INITIAL_POSITION = new Point(10, 10);
    private Color lastItemInsertedColor = Color.BLUE;
    private Color defaultItemColor = Color.BLACK;
    private JLabel lastItemInserted;
    private Color lastScopeCreatedColor = Color.BLUE;
    private Color defaultScopeColor = Color.BLACK;
    private int fontSize = 12;

    public SimpleSymbolTable() {
        this.visualization = new GraphicPanel();
        this.init();
        logger.setLevel(Level.OFF);
        logger.info("Symbol table has been created succesfully");
    }

    public void init() {
        this.rootNode = null;
        this.actualNode = null;
        this.jscope = null;
        this.searchNodes = new ArrayList<Scope>();
        this.identifierSearched = null;
        this.what = null;
        this.cleanSearch = false;
        this.visualScopes = new HashMap<Scope, JScope>();
        this.visualization.removeAll();
        this.visualization.setDesignMode(false);
        this.visualization.setPopupMenuEnabled(false);
        this.visualization.setLocation(0, 0);
        this.visualization.setSize(this.visualization.getPreferredSize());
        this.visualization.validate();
    }

    public SymbolTable.AddReport addItem(Item item) {
        SymbolTable.AddReport report;
        if (this.allowNestedIdentifiers) {
            report = this.actualNode.addItem(item);
        } else {
            Scope actual = this.actualNode;
            report = SymbolTable.AddReport.SUCCESFULY;
            while (actual != null) {
                Item i;
                if (actual.items.containsKey(item.getIdentifier()) && ((i = actual.items.get(item.getIdentifier())).getNature() != Item.Nature.SUBPROGRAM || !this.allowOverrideSubprogramAndVariable)) {
                    report = SymbolTable.AddReport.DUPLICATED_IDENTIFIER;
                }
                actual = actual.getParent();
            }
            if (report == SymbolTable.AddReport.SUCCESFULY) {
                this.actualNode.addItem(item);
            }
        }
        if (report == SymbolTable.AddReport.SUCCESFULY) {
            this.jscope.addItem(item, this.fontSize);
            JLabel label = this.jscope.getLabel(item);
            if (item == null) {
                throw new Error("El item no se encuentra en el componente");
            }
            label.setForeground(this.lastItemInsertedColor);
            if (this.lastItemInserted != null) {
                this.lastItemInserted.setForeground(this.defaultItemColor);
            }
            this.lastItemInserted = label;
            this.updateLayoutIfNecessary();
            logger.info("Item '" + item.getIdentifier() + "' added succesfully");
        } else {
            logger.info("Item '" + item.getIdentifier() + "' duplicated");
        }
        return report;
    }

    private void addScope(JScope newScope, String identifier) {
        int x = this.getXLocation(newScope);
        int y = this.getYLocation(newScope);
        newScope.setLocation(x, y);
        newScope.setBorder(BorderFactory.createLineBorder(this.lastScopeCreatedColor, 2));
        this.updateOldScopeIfNecessary(BorderFactory.createLineBorder(this.defaultScopeColor, 1));
        this.visualScopes.put(this.actualNode, newScope);
        this.visualization.add(newScope);
        this.createConnectorIfNecessary(identifier, newScope);
        this.jscope = newScope;
    }

    public void createScope() {
        this.actualNode = new Scope(this.actualNode);
        JScope newScope = new JScope();
        this.addScope(newScope, null);
        logger.info("Scope created");
    }

    public SymbolTable.AddReport createSubprogramScope(String identifier, String returnType) {
        if (this.actualNode != null) {
            if (!this.actualNode.items.containsKey(identifier) || this.allowOverrideSubprogramAndVariable) {
                this.addItem(new Item(identifier, returnType, Item.Nature.SUBPROGRAM));
            } else {
                logger.info("Subprogram '" + identifier + "' can't be added: Duplicated identifier");
                return SymbolTable.AddReport.DUPLICATED_IDENTIFIER;
            }
        }
        this.actualNode = new SubprogramScope(this.actualNode, identifier, returnType);
        JScope jsubp = new JScope(JScope.ScopeType.SUBPROGRAM);
        this.addScope(jsubp, identifier);
        logger.info("Subprogram '" + identifier + "' added succesfully");
        return SymbolTable.AddReport.SUCCESFULY;
    }

    private void createConnectorIfNecessary(String startPointItem, JScope endPoint) {
        if (this.jscope != null) {
            Connector c = new Connector(this.visualization, new ArrowDrawConnector(true));
            if (startPointItem != null) {
                JLabel label = this.jscope.getLabel(this.actualNode.getParent().items.get(startPointItem));
                c.setOriginComponent(label);
                int x = label.getFontMetrics(label.getFont()).stringWidth(" )");
                c.setOriginAnchor(label.getWidth() - x, label.getHeight() / 2 + 2);
            } else {
                c.setOriginComponent(this.jscope);
            }
            c.setEndComponent(endPoint);
            c.setEndAnchor(0, 0);
            this.visualization.addConnector(c);
        }
    }

    public void exitScope() {
        JScope actualScope = this.visualScopes.get(this.actualNode);
        actualScope.removeVariables();
        Scope parent = this.actualNode.getParent();
        ArrayList<Item> itemsToDelete = new ArrayList<Item>();
        for (Item i : this.actualNode.items.values()) {
            Item.Nature nature = i.getNature();
            if (nature != Item.Nature.VARIABLE && nature != Item.Nature.SUBPROGRAM) continue;
            itemsToDelete.add(i);
        }
        for (Item i : itemsToDelete) {
            this.actualNode.removeItem(i.getIdentifier());
        }
        if (this.actualNode.items.isEmpty()) {
            GraphicElement ge = this.visualization.getGraphicElement(actualScope);
            this.visualization.remove(ge);
            if (parent != null) {
                parent.removeChild(this.actualNode);
            }
            this.visualScopes.remove(this.actualNode);
        }
        for (Scope s : this.actualNode.children) {
            JScope visualScope = this.visualScopes.get(s);
            GraphicElement ge = this.visualization.getGraphicElement(visualScope);
            this.visualization.remove(ge);
        }
        this.actualNode.children.clear();
        this.jscope.setBorder(BorderFactory.createLineBorder(this.defaultScopeColor, 1));
        this.actualNode = parent;
        this.jscope = this.visualScopes.get(this.actualNode);
        this.updateOldScopeIfNecessary(BorderFactory.createLineBorder(this.lastScopeCreatedColor, 2));
        logger.info("Scope exited");
    }

    public void nextAnimationStep() {
        if (this.cleanSearch) {
            this.clean();
            return;
        }
        Scope lastScope = this.searchNodes.get(this.searchNodes.size() - 1);
        JScope js = this.visualScopes.get(lastScope);
        js.setTachado(true);
        logger.info("Computing next animation step");
        js.setHighlighted(false);
        lastScope = lastScope.getParent();
        if (lastScope == null) {
            logger.info("Not found. Search finished");
            this.found();
            this.searchNodes.clear();
            return;
        }
        this.searchNodes.add(lastScope);
        JScope actualScope = this.visualScopes.get(lastScope);
        actualScope.setHighlighted(true);
        if (this.what == WhatSearched.ITEM) {
            if (lastScope.items.containsKey(this.identifierSearched)) {
                logger.info("Search finished");
                actualScope.highlightItem(lastScope.items.get(this.identifierSearched));
                this.found();
            }
        } else if (this.what == WhatSearched.SUBPROGRAM) {
            if (lastScope.items.containsKey(this.identifierSearched)) {
                logger.info("Search finished");
                actualScope.highlightItem(lastScope.items.get(this.identifierSearched));
                this.found();
            }
        } else if (this.what == WhatSearched.BOTH && lastScope.items.containsKey(this.identifierSearched)) {
            logger.info("Search finished");
            actualScope.highlightItem(lastScope.items.get(this.identifierSearched));
            this.found();
        }
    }

    public void initSearchItem(String identifier) {
        this.searchNodes.clear();
        logger.info("init search item: '" + identifier + "'");
        this.identifierSearched = identifier;
        this.what = WhatSearched.ITEM;
        this.searchNodes.add(this.actualNode);
        JScope actualScope = this.visualScopes.get(this.actualNode);
        actualScope.setHighlighted(true);
        if (this.actualNode.items.containsKey(identifier) && this.actualNode.items.get(identifier).getNature() != Item.Nature.SUBPROGRAM) {
            actualScope.highlightItem(this.actualNode.items.get(identifier));
            logger.info("Item found");
            this.found();
        }
    }

    public void initSearchMethod(String identifier) {
        this.searchNodes.clear();
        logger.info("init search method '" + identifier + "'");
        this.identifierSearched = identifier;
        this.what = WhatSearched.SUBPROGRAM;
        this.searchNodes.add(this.actualNode);
        JScope actualScope = this.visualScopes.get(this.actualNode);
        actualScope.setHighlighted(true);
        if (this.actualNode.items.containsKey(identifier) && this.actualNode.items.get(identifier).getNature() == Item.Nature.SUBPROGRAM) {
            actualScope.highlightItem(this.actualNode.items.get(identifier));
            logger.info("Method found");
            this.found();
        }
    }

    public Item getItemFound() {
        if (this.searchNodes.isEmpty()) {
            return null;
        }
        return this.searchNodes.get((int)(this.searchNodes.size() - 1)).items.get(this.identifierSearched);
    }

    public Subprogram getSubprogramFound() {
        if (this.searchNodes.isEmpty()) {
            return null;
        }
        if (this.searchNodes.get(this.searchNodes.size() - 1) instanceof Subprogram) {
            return (Subprogram)((Object)this.searchNodes.get(this.searchNodes.size() - 1));
        }
        return null;
    }

    public void initSearchMethodOrItem(String identifier) {
        this.searchNodes.clear();
        logger.info("init search item or method '" + identifier + "'");
        this.identifierSearched = identifier;
        this.what = WhatSearched.BOTH;
        this.searchNodes.add(this.actualNode);
        JScope actualScope = this.visualScopes.get(this.actualNode);
        actualScope.setHighlighted(true);
        if (this.actualNode.items.containsKey(identifier)) {
            actualScope.highlightItem(this.actualNode.items.get(identifier));
            logger.info("Method or item found");
            this.found();
        }
    }

    private void found() {
        this.cleanSearch = true;
    }

    private void clean() {
        super.fireSearchFinished();
        for (JScope visualScope : this.visualScopes.values()) {
            visualScope.clean();
        }
        this.cleanSearch = false;
    }

    public boolean isOverridingSubprogramAndVariable() {
        return this.allowOverrideSubprogramAndVariable;
    }

    public void setOverridingSubprogramAndVariable(boolean value) {
        this.allowOverrideSubprogramAndVariable = value;
    }

    public JComponent getJComponent() {
        return this.visualization;
    }

    public boolean isAllowNestedIdentifiers() {
        return this.allowNestedIdentifiers;
    }

    public void setAllowNestedIdentifiers(boolean allowNestedIdentifiers) {
        this.allowNestedIdentifiers = allowNestedIdentifiers;
    }

    private int getYLocation(JScope newScope) {
        if (this.jscope == null) {
            return SimpleSymbolTable.INITIAL_POSITION.y;
        }
        if (this.actualNode instanceof Subprogram) {
            if (this.actualNode.getParent() == null) {
                return SimpleSymbolTable.INITIAL_POSITION.y;
            }
            int maxY = SimpleSymbolTable.INITIAL_POSITION.y;
            for (Scope scope : this.actualNode.getParent().children) {
                JScope visualScope;
                int y;
                if (scope == this.actualNode || (y = (visualScope = this.visualScopes.get(scope)).getY() + visualScope.getHeight() + 20) <= maxY) continue;
                maxY = y;
            }
            return maxY;
        }
        return this.jscope.getY() + this.jscope.getHeight() + 20;
    }

    private int getXLocation(JScope newScope) {
        if (this.jscope == null) {
            return SimpleSymbolTable.INITIAL_POSITION.x;
        }
        if (this.actualNode instanceof Subprogram) {
            return this.jscope.getX() + this.jscope.getWidth() + 50;
        }
        return this.jscope.getX();
    }

    public Color getLastItemInsertedColor() {
        return this.lastItemInsertedColor;
    }

    public void setLastItemInsertedColor(Color lastItemInsertedColor) {
        this.lastItemInsertedColor = lastItemInsertedColor;
    }

    public Color getDefaultItemColor() {
        return this.defaultItemColor;
    }

    public void setDefaultItemColor(Color defaultItemColor) {
        this.defaultItemColor = defaultItemColor;
    }

    private void updateOldScopeIfNecessary(Border border) {
        if (this.jscope != null) {
            this.jscope.setBorder(border);
            this.jscope.setSize(this.jscope.getPreferredSize());
        }
    }

    public void setFontSize(int size) {
        this.fontSize = size;
        this.updateLayoutIfNecessary();
    }

    private void updateLayoutIfNecessary() {
        if (this.actualNode == null) {
            return;
        }
        Scope scope = this.actualNode;
        while (scope.getParent() != null) {
            scope = scope.getParent();
        }
        Stack<LocationScope> stack = new Stack<LocationScope>();
        stack.push(new LocationScope(scope, SimpleSymbolTable.INITIAL_POSITION.x, SimpleSymbolTable.INITIAL_POSITION.y));
        while (!stack.isEmpty()) {
            LocationScope ls = (LocationScope)stack.pop();
            JScope js = this.visualScopes.get(ls.s);
            js.setLocation(ls.x, ls.y);
            if (js != null) {
                js.setFontSize(this.fontSize);
            }
            int y = ls.y;
            for (Scope child : ls.s.children) {
                if (child instanceof Subprogram) {
                    stack.push(new LocationScope(child, ls.x + js.getWidth() + 50, y));
                    y += this.visualScopes.get(child).getHeight() + 20;
                    continue;
                }
                stack.push(new LocationScope(child, ls.x, ls.y + js.getHeight() + 20));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum WhatSearched {
        ITEM,
        SUBPROGRAM,
        BOTH;

    }

    class LocationScope {
        Scope s;
        int x;
        int y;

        public LocationScope(Scope scope, int x, int y) {
            this.s = scope;
            this.x = x;
            this.y = y;
        }
    }
}

